-- VHDL Entity FACT_FAD_lib.FAD_Board.symbol
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 21:52:14 22.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY FAD_Board IS
   PORT( 
      A0_D       : IN     std_logic_vector (11 DOWNTO 0);
      A1_D       : IN     std_logic_vector (11 DOWNTO 0);
      A2_D       : IN     std_logic_vector (11 DOWNTO 0);
      A3_D       : IN     std_logic_vector (11 DOWNTO 0);
      A_OTR      : IN     std_logic_vector (3 DOWNTO 0);
      D0_SROUT   : IN     std_logic;
      D1_SROUT   : IN     std_logic;
      D2_SROUT   : IN     std_logic;
      D3_SROUT   : IN     std_logic;
      D_PLLLCK   : IN     std_logic_vector (3 DOWNTO 0);
      D_T_in     : IN     std_logic_vector (1 DOWNTO 0);
      LINE       : IN     std_logic_vector ( 5 DOWNTO 0 );
      REFCLK     : IN     std_logic;
      RS485_E_DI : IN     std_logic;
      TRG        : IN     STD_LOGIC;
      W_INT      : IN     std_logic;
      X_50M      : IN     STD_LOGIC;
      A0_T       : OUT    std_logic_vector (7 DOWNTO 0)   := (others => '0');
      A1_T       : OUT    std_logic_vector (7 DOWNTO 0)   := (OTHERS => '0');
      AMBER_LED  : OUT    std_logic;
      A_CLK      : OUT    std_logic_vector (3 DOWNTO 0);
      DAC_CS     : OUT    std_logic;
      DENABLE    : OUT    std_logic                       := '0';
      DSRCLK     : OUT    std_logic_vector (3 DOWNTO 0)   := (others => '0');
      DWRITE     : OUT    std_logic                       := '0';
      D_A        : OUT    std_logic_vector (3 DOWNTO 0)   := (others => '0');
      D_T        : OUT    std_logic_vector (7 DOWNTO 0)   := (OTHERS => '0');
      D_T2       : OUT    std_logic_vector (1 DOWNTO 0)   := (others => '0');
      EE_CS      : OUT    std_logic;
      GREEN_LED  : OUT    std_logic;
      MOSI       : OUT    std_logic                       := '0';
      OE_ADC     : OUT    STD_LOGIC;
      RED_LED    : OUT    std_logic;
      RS485_C_DE : OUT    std_logic;
      RS485_C_DO : OUT    std_logic;
      RS485_C_RE : OUT    std_logic;
      RS485_E_DE : OUT    std_logic;
      RS485_E_DO : OUT    std_logic;
      RS485_E_RE : OUT    std_logic;
      RSRLOAD    : OUT    std_logic                       := '0';
      SRIN       : OUT    std_logic                       := '0';
      S_CLK      : OUT    std_logic;
      TCS        : OUT    std_logic_vector (3 DOWNTO 0);
      TRG_V      : OUT    std_logic                       := '0';
      W_A        : OUT    std_logic_vector (9 DOWNTO 0);
      W_CS       : OUT    std_logic                       := '1';
      W_RD       : OUT    std_logic                       := '1';
      W_RES      : OUT    std_logic                       := '1';
      W_T        : OUT    std_logic_vector ( 3 DOWNTO 0 ) := (others => '0');
      W_WR       : OUT    std_logic                       := '1';
      MISO       : INOUT  std_logic;
      W_D        : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_Board ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_Board.struct
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 21:52:15 22.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.NUMERIC_STD.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF FAD_Board IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL ADC_CLK               : std_logic;
   SIGNAL CLK_50                : std_logic;
   -- for debugging
   SIGNAL DG_state              : std_logic_vector(7 DOWNTO 0);
   SIGNAL SRCLK                 : std_logic                     := '0';
   SIGNAL adc_data_array        : adc_data_array_type;
   SIGNAL alarm_refclk_too_high : std_logic                     := '0';
   SIGNAL alarm_refclk_too_low  : std_logic                     := '0';
   SIGNAL board_id              : std_logic_vector(3 DOWNTO 0);
   SIGNAL counter_result        : std_logic_vector(11 DOWNTO 0) := (others => '0');
   SIGNAL crate_id              : std_logic_vector(1 DOWNTO 0);
   SIGNAL dac_cs1               : std_logic;
   SIGNAL debug_data_ram_empty  : std_logic;
   SIGNAL debug_data_valid      : std_logic;
   SIGNAL led                   : std_logic_vector(7 DOWNTO 0)  := (OTHERS => '0');
   SIGNAL mem_manager_state     : std_logic_vector(3 DOWNTO 0);                        -- state is encoded here ... useful for debugging.
   SIGNAL mosi1                 : std_logic;
   SIGNAL sclk                  : std_logic;
   SIGNAL sensor_cs             : std_logic_vector(3 DOWNTO 0);
   SIGNAL socket_tx_free_out    : std_logic_vector(16 DOWNTO 0);                       -- 17bit value .. that's true
   SIGNAL trigger_veto          : std_logic                     := '1';
   SIGNAL w5300_state           : std_logic_vector(7 DOWNTO 0);                        -- state is encoded here ... useful for debugging.

   -- Implicit buffer signal declarations
   SIGNAL TRG_V_internal : std_logic;


   -- Component Declarations
   COMPONENT FAD_main
   GENERIC (
      RAMADDRWIDTH64b : integer := 12
   );
   PORT (
      CLK                   : IN     std_logic ;
      D_T_in                : IN     std_logic_vector (1 DOWNTO 0);
      FTM_RS485_rx_d        : IN     std_logic ;
      SROUT_in_0            : IN     std_logic ;
      SROUT_in_1            : IN     std_logic ;
      SROUT_in_2            : IN     std_logic ;
      SROUT_in_3            : IN     std_logic ;
      adc_data_array        : IN     adc_data_array_type ;
      adc_otr_array         : IN     std_logic_vector (3 DOWNTO 0);
      board_id              : IN     std_logic_vector (3 DOWNTO 0);
      crate_id              : IN     std_logic_vector (1 DOWNTO 0);
      drs_refclk_in         : IN     std_logic ;                                     -- used TO check if DRS REFCLK exsists, if not DENABLE inhibit
      plllock_in            : IN     std_logic_vector (3 DOWNTO 0);                  -- high level, if dominowave is running and DRS PLL locked
      trigger               : IN     std_logic ;
      wiz_int               : IN     std_logic ;
      ADC_CLK               : OUT    std_logic ;
      CLK_25_PS             : OUT    std_logic ;
      CLK_50                : OUT    std_logic ;
      -- for debugging
      DG_state              : OUT    std_logic_vector (7 DOWNTO 0);
      FTM_RS485_rx_en       : OUT    std_logic ;
      FTM_RS485_tx_d        : OUT    std_logic ;
      FTM_RS485_tx_en       : OUT    std_logic ;
      RSRLOAD               : OUT    std_logic                     := '0';
      SRCLK                 : OUT    std_logic                     := '0';
      SRIN_out              : OUT    std_logic                     := '0';
      adc_oeb               : OUT    std_logic                     := '1';
      alarm_refclk_too_high : OUT    std_logic ;
      alarm_refclk_too_low  : OUT    std_logic ;
      amber                 : OUT    std_logic ;
      counter_result        : OUT    std_logic_vector (11 DOWNTO 0);
      dac_cs                : OUT    std_logic ;
      debug_data_ram_empty  : OUT    std_logic ;
      debug_data_valid      : OUT    std_logic ;
      denable               : OUT    std_logic                     := '0';           -- default domino wave off
      drs_channel_id        : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite            : OUT    std_logic                     := '1';
      green                 : OUT    std_logic ;
      led                   : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mem_manager_state     : OUT    std_logic_vector (3 DOWNTO 0);                  -- state is encoded here ... useful for debugging.
      mosi                  : OUT    std_logic                     := '0';
      red                   : OUT    std_logic ;
      sclk                  : OUT    std_logic ;
      sensor_cs             : OUT    std_logic_vector (3 DOWNTO 0);
      socket_tx_free_out    : OUT    std_logic_vector (16 DOWNTO 0);                 -- 17bit value .. that's true
      trigger_veto          : OUT    std_logic                     := '1';
      w5300_state           : OUT    std_logic_vector (7 DOWNTO 0);                  -- state is encoded here ... useful for debugging.
      wiz_addr              : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs                : OUT    std_logic                     := '1';
      wiz_rd                : OUT    std_logic                     := '1';
      wiz_reset             : OUT    std_logic                     := '1';
      wiz_wr                : OUT    std_logic                     := '1';
      sio                   : INOUT  std_logic ;
      wiz_data              : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 SRCLK
   DSRCLK <= ( SRCLK, SRCLK,SRCLK,SRCLK);

   -- HDL Embedded Text Block 2 ADC_CLK
   A_CLK <= (
   ADC_CLK,
   ADC_CLK,
   ADC_CLK,
   ADC_CLK
   );

   -- HDL Embedded Text Block 3 ADC_DATA
   adc_data_array <= ( A0_D, A1_D, A2_D, A3_D );

   -- HDL Embedded Text Block 4 eb_ID
   -- hard-wired IDs
   board_id <= LINE(5 downto 2);
   crate_id <= LINE(1 downto 0);

   -- HDL Embedded Text Block 9 eb3
   -- testpins D_T2 are used as MAX3485 outputs.
   
   --D_T <= (others => '0');
   D_T <= w5300_state;
   --D_T2(0) <= debug_data_valid;
   D_T2(0) <= debug_data_ram_empty;
   --D_T2(1) <= socket_tx_free_out(16);
   
   D_T2(1) <= TRG_V_internal;
   --D_T2 <= ( others => '0' );
   
   
   A0_T <= (others => '0');
   A1_T <= (others => '1');
   
   
   --A0_T <= DG_state;
   W_T(3 downto 0) <= mem_manager_state;
   --A1_T(7 downto 4) <= "1100";
   
   --A0_T <= socket_tx_free_out(7 downto 0);
   --A0_T <= spi_debug_16bit(7 downto 0);
   --A1_T <= spi_debug_16bit(15 downto 8);
   --A1_T <= socket_tx_free_out(15 downto 8);
   
   -- check SPI interfac
   --A1_T(7) <= sclk;
   --A1_T(6) <= MISO;
   --A1_T(5) <= mosi1;
   
   --A1_T(4) <= dac_cs1;
   --A1_T( 3 downto 0) <= sensor_cs;
   
   
   --D_T(3 downto 0) <=  counter_result ( 11 downto 8);
   --D_T(4) <= alarm_refclk_too_low;
   --D_T(5) <= alarm_refclk_too_high;
   --D_T(6) <= '0';
   --D_T(7) <= '0';
   
   
   
   -- additional MAX3485 is switched to shutdown mode
   RS485_C_RE <= '1';  --inverted logic
   RS485_C_DE <= '0';   
   RS485_C_DO <= '0';
   -- MAX3485 receiver out pit is fed out... should be HIGH-Z
   
   
   -- EEPROM is not used on FAD. CS is always high.
   EE_CS <= '1';


   -- ModuleWare code(v1.9) for instance 'I0' of 'assignment'
   DAC_CS <= dac_cs1;

   -- ModuleWare code(v1.9) for instance 'I1' of 'assignment'
   TCS <= sensor_cs;

   -- ModuleWare code(v1.9) for instance 'I2' of 'assignment'
   S_CLK <= sclk;

   -- ModuleWare code(v1.9) for instance 'I3' of 'assignment'
   MOSI <= mosi1;

   -- ModuleWare code(v1.9) for instance 'I4' of 'assignment'
   TRG_V_internal <= trigger_veto;

   -- Instance port mappings.
   I_board_main : FAD_main
      GENERIC MAP (
         RAMADDRWIDTH64b => LOG2_OF_RAM_SIZE_64B
      )
      PORT MAP (
         CLK                   => X_50M,
         D_T_in                => D_T_in,
         FTM_RS485_rx_d        => RS485_E_DI,
         SROUT_in_0            => D0_SROUT,
         SROUT_in_1            => D1_SROUT,
         SROUT_in_2            => D2_SROUT,
         SROUT_in_3            => D3_SROUT,
         adc_data_array        => adc_data_array,
         adc_otr_array         => A_OTR,
         board_id              => board_id,
         crate_id              => crate_id,
         drs_refclk_in         => REFCLK,
         plllock_in            => D_PLLLCK,
         trigger               => TRG,
         wiz_int               => W_INT,
         ADC_CLK               => ADC_CLK,
         CLK_25_PS             => OPEN,
         CLK_50                => CLK_50,
         DG_state              => DG_state,
         FTM_RS485_rx_en       => RS485_E_RE,
         FTM_RS485_tx_d        => RS485_E_DO,
         FTM_RS485_tx_en       => RS485_E_DE,
         RSRLOAD               => RSRLOAD,
         SRCLK                 => SRCLK,
         SRIN_out              => SRIN,
         adc_oeb               => OE_ADC,
         alarm_refclk_too_high => alarm_refclk_too_high,
         alarm_refclk_too_low  => alarm_refclk_too_low,
         amber                 => AMBER_LED,
         counter_result        => counter_result,
         dac_cs                => dac_cs1,
         debug_data_ram_empty  => debug_data_ram_empty,
         debug_data_valid      => debug_data_valid,
         denable               => DENABLE,
         drs_channel_id        => D_A,
         drs_dwrite            => DWRITE,
         green                 => GREEN_LED,
         led                   => led,
         mem_manager_state     => mem_manager_state,
         mosi                  => mosi1,
         red                   => RED_LED,
         sclk                  => sclk,
         sensor_cs             => sensor_cs,
         socket_tx_free_out    => socket_tx_free_out,
         trigger_veto          => trigger_veto,
         w5300_state           => w5300_state,
         wiz_addr              => W_A,
         wiz_cs                => W_CS,
         wiz_rd                => W_RD,
         wiz_reset             => W_RES,
         wiz_wr                => W_WR,
         sio                   => MISO,
         wiz_data              => W_D
      );

   -- Implicit buffered output assignments
   TRG_V <= TRG_V_internal;

END struct;
