-- VHDL Entity FACT_FAD_lib.FAD_main.symbol
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 15:01:18 24.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

ENTITY FAD_main IS
   GENERIC( 
      RAMADDRWIDTH64b : integer := 12
   );
   PORT( 
      CLK                   : IN     std_logic;
      D_T_in                : IN     std_logic_vector (1 DOWNTO 0);
      FTM_RS485_rx_d        : IN     std_logic;
      SROUT_in_0            : IN     std_logic;
      SROUT_in_1            : IN     std_logic;
      SROUT_in_2            : IN     std_logic;
      SROUT_in_3            : IN     std_logic;
      adc_data_array        : IN     adc_data_array_type;
      adc_otr_array         : IN     std_logic_vector (3 DOWNTO 0);
      board_id              : IN     std_logic_vector (3 DOWNTO 0);
      crate_id              : IN     std_logic_vector (1 DOWNTO 0);
      drs_refclk_in         : IN     std_logic;                                         -- used to check if DRS REFCLK exsists, if not DENABLE inhibit
      plllock_in            : IN     std_logic_vector (3 DOWNTO 0);                     -- high level, if dominowave is running and DRS PLL locked
      trigger               : IN     std_logic;
      wiz_int               : IN     std_logic;
      ADC_CLK               : OUT    std_logic;
      CLK_25_PS             : OUT    std_logic;
      CLK_50                : OUT    std_logic;
      -- for debugging
      DG_state              : OUT    std_logic_vector (7 DOWNTO 0);
      FTM_RS485_rx_en       : OUT    std_logic;
      FTM_RS485_tx_d        : OUT    std_logic;
      FTM_RS485_tx_en       : OUT    std_logic;
      RSRLOAD               : OUT    std_logic                     := '0';
      SRCLK                 : OUT    std_logic                     := '0';
      SRIN_out              : OUT    std_logic                     := '0';
      adc_oeb               : OUT    std_logic                     := '1';
      alarm_refclk_too_high : OUT    std_logic;
      alarm_refclk_too_low  : OUT    std_logic;
      amber                 : OUT    std_logic;
      counter_result        : OUT    std_logic_vector (11 DOWNTO 0);
      dac_cs                : OUT    std_logic;
      debug_data_ram_empty  : OUT    std_logic;
      debug_data_valid      : OUT    std_logic;
      denable               : OUT    std_logic                     := '0';              -- default domino wave off
      drs_channel_id        : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite            : OUT    std_logic                     := '1';
      green                 : OUT    std_logic;
      led                   : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mem_manager_state     : OUT    std_logic_vector (3 DOWNTO 0);                     -- state is encoded here ... useful for debugging.
      mosi                  : OUT    std_logic                     := '0';
      red                   : OUT    std_logic;
      sclk                  : OUT    std_logic;
      sensor_cs             : OUT    std_logic_vector (3 DOWNTO 0);
      socket_tx_free_out    : OUT    std_logic_vector (16 DOWNTO 0);                    -- 17bit value .. that's true
      trigger_veto          : OUT    std_logic                     := '1';
      w5300_state           : OUT    std_logic_vector (7 DOWNTO 0);                     -- state is encoded here ... useful for debugging.
      wiz_addr              : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs                : OUT    std_logic                     := '1';
      wiz_rd                : OUT    std_logic                     := '1';
      wiz_reset             : OUT    std_logic                     := '1';
      wiz_wr                : OUT    std_logic                     := '1';
      sio                   : INOUT  std_logic;
      wiz_data              : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_main ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_main.struct
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 15:01:19 24.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
library ieee;
use ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_UNSIGNED.all;

library fact_fad_lib;
use fact_fad_lib.fad_definitions.all;

library UNISIM;
--use UNISIM.VComponents.all;
USE IEEE.NUMERIC_STD.all;
USE IEEE.std_logic_signed.all;
USE fact_fad_lib.fad_rs485_constants.all;
LIBRARY hds_package_library;
USE hds_package_library.random_generators.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF FAD_main IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK_25                       : std_logic;
   SIGNAL DCM_PS_status                : std_logic_vector(7 DOWNTO 0)                 := (OTHERS => '0');
   SIGNAL DCM_locked_status            : std_logic;
   SIGNAL DCM_ready_status             : std_logic;
   --

-- EVT HEADER - part 2  --> FTM trigger informaton, comes in late ...
-- during EVT header wrinting, this field is left out ... and only written into event header,
-- when the DRS chip were read out already.
   SIGNAL FTM_RS485_ready              : std_logic;
   SIGNAL I_really_want_dwrite         : STD_LOGIC;
   SIGNAL SRCLK1                       : std_logic                                    := '0';
   SIGNAL adc_clk_en                   : std_logic;
   SIGNAL adc_data_array_int           : adc_data_array_type;
   SIGNAL adc_otr                      : std_logic_vector(3 DOWNTO 0);
   SIGNAL addr_out                     : std_logic_vector(RAMADDRWIDTH64b-1 DOWNTO 0);
   SIGNAL busy_enable                  : std_logic                                    := '1';
   SIGNAL c_trigger_enable             : std_logic                                    := '0';
   SIGNAL c_trigger_mult               : std_logic_vector(15 DOWNTO 0);
   SIGNAL cont_trigger                 : std_logic;
   SIGNAL current_dac_array            : dac_array_type                               := ( others => 0);
   SIGNAL dac_setting                  : dac_array_type                               := DEFAULT_DAC;        --<<-- default defined in fad_definitions.vhd
   SIGNAL data_out                     : std_logic_vector(63 DOWNTO 0);
   SIGNAL data_ram_empty               : std_logic;
   SIGNAL data_valid_ack               : std_logic                                    := '0';
   SIGNAL denable_prim                 : std_logic                                    := '0';                -- default domino wave off
   SIGNAL denable_sig                  : std_logic                                    := '0';                -- default domino wave off
   SIGNAL dg_config_done               : std_logic;
   SIGNAL dg_start_config              : std_logic                                    := '0';
   SIGNAL din1                         : std_logic                                    := '0';                -- default domino wave off
   SIGNAL dna                          : STD_LOGIC_VECTOR(63 DOWNTO 0)                := (others => '0');
   SIGNAL dout                         : STD_LOGIC;
   SIGNAL dout0                        : STD_LOGIC;
   SIGNAL dout1                        : STD_LOGIC;
   SIGNAL dout2                        : STD_LOGIC;
   SIGNAL dout3                        : STD_LOGIC;
   SIGNAL dout4                        : STD_LOGIC;
   SIGNAL dout5                        : std_logic;
   SIGNAL dout6                        : std_logic;
   SIGNAL dout7                        : std_logic;
   SIGNAL drs_clk_en                   : std_logic                                    := '0';
   SIGNAL drs_read_s_cell              : std_logic                                    := '0';
   SIGNAL drs_read_s_cell_ready        : std_logic;
   -- --
--      drs_dwrite : out std_logic := '1';
   SIGNAL drs_readout_ready            : std_logic                                    := '0';
   SIGNAL drs_readout_ready_ack        : std_logic;
   SIGNAL drs_readout_started          : std_logic;
   SIGNAL drs_s_cell_array             : drs_s_cell_array_type;
   SIGNAL drs_srin_data                : std_logic_vector(7 DOWNTO 0)                 := (others => '0');
   SIGNAL dwrite_enable_w5300          : std_logic                                    := '1';
   SIGNAL dwrite_global_enable         : std_logic                                    := '1';
   SIGNAL dwrite_trigger_manager       : std_logic                                    := '1';
   SIGNAL enable_i                     : std_logic;
   SIGNAL enabled_trigger_or_s_trigger : std_logic;
   SIGNAL is_idle                      : std_logic;
   SIGNAL memory_manager_config_start  : std_logic                                    := '0';
   SIGNAL memory_manager_config_valid  : std_logic;
   SIGNAL package_length               : std_logic_vector(15 DOWNTO 0);
   SIGNAL ps_direction                 : std_logic                                    := '1';                -- default phase shift upwards
   SIGNAL ps_do_phase_shift            : std_logic                                    := '0';                --pulse this to phase shift once
   SIGNAL ps_reset                     : std_logic                                    := '0';                -- pulse this to reset the variable phase shift
   SIGNAL ram_addr                     : std_logic_vector(RAMADDRWIDTH64b+1 DOWNTO 0);
   SIGNAL ram_data                     : std_logic_vector(15 DOWNTO 0);
   SIGNAL ram_start_addr               : std_logic_vector(RAMADDRWIDTH64b-1 DOWNTO 0);
   SIGNAL ram_write_ea                 : std_logic;
   SIGNAL ram_write_ready              : std_logic                                    := '0';
   SIGNAL ready                        : STD_LOGIC                                    := '0';
   SIGNAL rec_timeout_occured          : std_logic                                    := '0';
   SIGNAL reset_synch_i                : std_logic;
   SIGNAL reset_trigger_id             : std_logic                                    := '0';
   SIGNAL roi_max                      : roi_max_type;
   SIGNAL roi_setting                  : roi_array_type;
   SIGNAL rs465_data                   : std_logic_vector(55 DOWNTO 0);                                      --7 byte
   -- EVT HEADER - part 6
   SIGNAL runnumber                    : std_logic_vector(31 DOWNTO 0);
   SIGNAL s_trigger                    : std_logic;
   SIGNAL sclk_enable                  : std_logic;
   SIGNAL sensor_array                 : sensor_array_type;
   SIGNAL sensor_ready                 : std_logic;
   SIGNAL socket_send_mode             : std_logic;
   SIGNAL socks_connected              : std_logic;
   SIGNAL socks_waiting                : std_logic;
   SIGNAL software_trigger_in          : std_logic;
   SIGNAL spi_interface_config_start   : std_logic                                    := '0';
   SIGNAL spi_interface_config_valid   : std_logic;
   SIGNAL srclk_enable                 : std_logic                                    := '0';
   SIGNAL srin_write_ack               : std_logic                                    := '0';
   SIGNAL srin_write_ready             : std_logic                                    := '0';
   SIGNAL start_srin_write_8b          : std_logic;
   SIGNAL time                         : std_logic_vector(31 DOWNTO 0);
   SIGNAL trig_veto                    : std_logic;
   SIGNAL trigger_enable               : std_logic;
   SIGNAL trigger_id                   : std_logic_vector(31 DOWNTO 0);
   SIGNAL trigger_or_s_trigger         : std_logic;
   SIGNAL trigger_out                  : std_logic;
   SIGNAL trigger_veto1                : std_logic                                    := '1';
   SIGNAL wiz_number_of_channels       : std_logic_vector(3 DOWNTO 0)                 := (others => '0');
   SIGNAL wiz_ram_start_addr           : std_logic_vector(RAMADDRWIDTH64b+1 DOWNTO 0) := (others => '0');
   SIGNAL wiz_reset_sig                : std_logic                                    := '1';
   SIGNAL wiz_write_ea                 : std_logic                                    := '0';
   SIGNAL wiz_write_end                : std_logic                                    := '0';
   SIGNAL wiz_write_header             : std_logic                                    := '0';
   SIGNAL wiz_write_length             : std_logic_vector(16 DOWNTO 0)                := (others => '0');
   SIGNAL write_ea                     : std_logic_vector(0 DOWNTO 0)                 := "0";

   -- Implicit buffer signal declarations
   SIGNAL CLK_25_PS_internal             : std_logic;
   SIGNAL CLK_50_internal                : std_logic;
   SIGNAL alarm_refclk_too_high_internal : std_logic;
   SIGNAL alarm_refclk_too_low_internal  : std_logic;
   SIGNAL counter_result_internal        : std_logic_vector (11 DOWNTO 0);


   -- ModuleWare signal declarations(v1.9) for instance 'U_0' of 'split'
   SIGNAL mw_U_0temp_din : std_logic_vector(3 DOWNTO 0);

   -- Component Declarations
   COMPONENT FAD_rs485_receiver
   GENERIC (
      -- defined in fad_rs485_definitions.fad_rs485_constants
      RX_BYTES : integer := RS485_MESSAGE_LEN_BYTES;         -- no. of bytes to receive
      RX_WIDTH : integer := RS485_MESSAGE_LEN_BYTES * 8      -- no. of bits to receive
   );
   PORT (
      rec_clk             : IN     std_logic;
      rec_start           : IN     std_logic;
      rx_d                : IN     std_logic;
      rec_dout            : OUT    std_logic_vector (RX_WIDTH - 1 DOWNTO 0) := (others => '0');
      rec_timeout_occured : OUT    std_logic                                := '0';
      rec_valid           : OUT    std_logic                                := '0';
      rx_en               : OUT    std_logic;
      tx_d                : OUT    std_logic;
      tx_en               : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT REFCLK_counter
   PORT (
      clk                   : IN     std_logic;
      refclk_in             : IN     std_logic;
      alarm_refclk_too_high : OUT    std_logic                      := '0';
      alarm_refclk_too_low  : OUT    std_logic                      := '0';
      counter_result        : OUT    std_logic_vector (11 DOWNTO 0) := (others => '0')
   );
   END COMPONENT;
   COMPONENT adc_buffer
   PORT (
      adc_data_array     : IN     adc_data_array_type;
      adc_otr_array      : IN     std_logic_vector (3 DOWNTO 0);
      clk_ps             : IN     std_logic;
      adc_data_array_int : OUT    adc_data_array_type;
      adc_otr            : OUT    std_logic_vector (3 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT clock_generator_var_ps
   PORT (
      CLK             : IN     std_logic ;
      RST_IN          : IN     std_logic ;
      direction       : IN     std_logic ;
      do_shift        : IN     std_logic ;
      CLK_25          : OUT    std_logic ;
      CLK_25_PS       : OUT    std_logic ;
      CLK_50          : OUT    std_logic ;
      locked_status_o : OUT    std_logic ;
      offset          : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      ready_status_o  : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT continous_pulser
   GENERIC (
      MINIMAL_TRIGGER_WAIT_TIME : integer := 250000;
      TRIGGER_WIDTH             : integer := 5
   );
   PORT (
      CLK        : IN     std_logic;
      enable     : IN     std_logic;
      multiplier : IN     std_logic_vector (15 DOWNTO 0);
      trigger    : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT dataRAM_64b_16b_width14_5
   PORT (
      clka  : IN     std_logic ;
      dina  : IN     std_logic_VECTOR (63 DOWNTO 0);
      addra : IN     std_logic_VECTOR (14 DOWNTO 0);
      wea   : IN     std_logic_VECTOR (0 DOWNTO 0);
      clkb  : IN     std_logic ;
      addrb : IN     std_logic_VECTOR (16 DOWNTO 0);
      doutb : OUT    std_logic_VECTOR (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT data_generator
   GENERIC (
      RAM_ADDR_WIDTH : integer := 12
   );
   PORT (
      -- for debugging
      state                      : OUT    std_logic_vector (7 DOWNTO 0);
      is_idle                    : OUT    std_logic ;
      clk                        : IN     std_logic ;                                     -- CLK_25.
      data_out                   : OUT    std_logic_vector (63 DOWNTO 0);
      addr_out                   : OUT    std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      dataRAM_write_ea_o         : OUT    std_logic_vector (0 DOWNTO 0) := "0";
      ram_start_addr             : IN     std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      ram_write_ea               : IN     std_logic ;
      ram_write_ready            : OUT    std_logic                     := '0';
      roi_array                  : IN     roi_array_type ;
      roi_max                    : IN     roi_max_type ;
      sensor_array               : IN     sensor_array_type ;
      sensor_ready               : IN     std_logic ;
      dac_array                  : IN     dac_array_type ;
      config_start               : IN     std_logic ;
      config_done                : OUT    std_logic                     := '0';
      -- EVT HEADER - part 1
      package_length             : IN     std_logic_vector (15 DOWNTO 0);
      pll_lock                   : IN     std_logic_vector ( 3 DOWNTO 0);
      dwrite_enable_in           : IN     std_logic ;
      denable_enable_in          : IN     std_logic ;
      busy_enable_in             : IN     std_logic ;
      trigger_enable_in          : IN     std_logic ;
      cont_trigger_en_in         : IN     std_logic ;
      socket_send_mode_in        : IN     std_logic ;
      -- EVT HEADER - part 2  --> FTM trigger informaton, comes in late ...
      -- during EVT header wrinting, this field is left out ... and only written into event header,
      -- when the DRS chip were read out already.
      FTM_RS485_ready            : IN     std_logic ;
      FTM_trigger_info           : IN     std_logic_vector (55 DOWNTO 0);                 --7 byte
      FTM_receiver_status        : IN     std_logic ;
      -- EVT HEADER - part 3
      fad_event_counter          : IN     std_logic_vector (31 DOWNTO 0);
      refclk_counter             : IN     std_logic_vector (11 DOWNTO 0);
      refclk_too_high            : IN     std_logic ;
      refclk_too_low             : IN     std_logic ;
      -- EVT HEADER - part 4
      board_id                   : IN     std_logic_vector (3 DOWNTO 0);
      crate_id                   : IN     std_logic_vector (1 DOWNTO 0);
      DCM_PS_status              : IN     std_logic_vector (7 DOWNTO 0);
      DCM_locked_status          : IN     std_logic ;
      DCM_ready_status           : IN     std_logic ;
      SPI_SCLK_enable_status     : IN     std_logic ;
      TRG_GEN_div                : IN     std_logic_vector (15 DOWNTO 0);
      -- EVT HEADER - part 5
      dna                        : IN     std_logic_vector (63 DOWNTO 0);
      -- EVT HEADER - part 6
      runnumber                  : IN     std_logic_vector (31 DOWNTO 0);
      timer_value                : IN     std_logic_vector (31 DOWNTO 0);                 -- time in units of 100us
      hardware_trigger_in        : IN     std_logic ;
      software_trigger_in        : IN     std_logic ;
      adc_data_array             : IN     adc_data_array_type ;
      adc_output_enable_inverted : OUT    std_logic                     := '1';
      adc_clk_en                 : OUT    std_logic                     := '0';
      adc_otr                    : IN     std_logic_vector (3 DOWNTO 0);
      drs_channel_id             : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      --drs_dwrite : out std_logic := '1';
      drs_readout_ready          : OUT    std_logic                     := '0';
      drs_readout_ready_ack      : IN     std_logic ;
      drs_clk_en                 : OUT    std_logic                     := '0';
      start_read_drs_stop_cell   : OUT    std_logic                     := '0';
      drs_srin_write_8b          : OUT    std_logic                     := '0';
      drs_srin_write_ack         : IN     std_logic ;
      drs_srin_data              : OUT    std_logic_vector (7 DOWNTO 0) := (others => '0');
      drs_srin_write_ready       : IN     std_logic ;
      drs_read_s_cell_ready      : IN     std_logic ;
      drs_s_cell_array           : IN     drs_s_cell_array_type ;
      drs_readout_started        : OUT    std_logic                     := '0';
      trigger_veto               : OUT    std_logic                     := '1'
   );
   END COMPONENT;
   COMPONENT dna_gen
   PORT (
      clk   : IN     STD_LOGIC ;
      dna   : OUT    STD_LOGIC_VECTOR (63 DOWNTO 0) := (others => '0');
      ready : OUT    STD_LOGIC                      := '0'
   );
   END COMPONENT;
   COMPONENT drs_pulser
   PORT (
      CLK                      : IN     std_logic;
      SROUT_in_0               : IN     std_logic;
      SROUT_in_1               : IN     std_logic;
      SROUT_in_2               : IN     std_logic;
      SROUT_in_3               : IN     std_logic;
      srin_data                : IN     std_logic_vector (7 DOWNTO 0);
      start_endless_mode       : IN     std_logic;
      start_read_stop_pos_mode : IN     std_logic;
      start_srin_write_8b      : IN     std_logic;
      RSRLOAD                  : OUT    std_logic  := '0';
      SRCLK                    : OUT    std_logic  := '0';
      SRIN_out                 : OUT    std_logic  := '0';
      srin_write_ack           : OUT    std_logic  := '0';
      srin_write_ready         : OUT    std_logic  := '0';
      stop_pos                 : OUT    drs_s_cell_array_type;
      stop_pos_valid           : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT led_controller
   GENERIC (
      HEARTBEAT_PWM_DIVIDER : integer := 500;
      WAITING_DIVIDER       : integer := 500000000
   );
   PORT (
      CLK                    : IN     std_logic;
      refclk_too_high        : IN     std_logic;
      refclk_too_low         : IN     std_logic;
      socks_connected        : IN     std_logic;
      socks_waiting          : IN     std_logic;
      trigger                : IN     std_logic;
      trigger_veto           : IN     std_logic;
      w5300_reset            : IN     std_logic;
      additional_flasher_out : OUT    std_logic;
      amber                  : OUT    std_logic;
      green                  : OUT    std_logic;
      red                    : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT memory_manager_2
   GENERIC (
      RAM_ADDR_WIDTH_64B : integer := 12;
      RAM_ADDR_WIDTH_16B : integer := 14
   );
   PORT (
      clk                    : IN     std_logic;
      config_start           : IN     std_logic;
      dg_config_done         : IN     std_logic;
      ram_write_ready        : IN     std_logic;
      roi_array              : IN     roi_array_type;
      wiz_read_done          : IN     std_logic;
      config_ready           : OUT    std_logic                                        := '1';
      data_ram_empty         : OUT    std_logic;
      dg_start_config        : OUT    std_logic                                        := '0';
      package_length         : OUT    std_logic_vector (15 DOWNTO 0)                   := (others => '0');
      ram_start_addr         : OUT    std_logic_vector (RAM_ADDR_WIDTH_64B-1 DOWNTO 0) := (others => '0');
      ram_write_ea           : OUT    std_logic                                        := '0';
      roi_max                : OUT    roi_max_type                                     := (others => conv_std_logic_vector (0, 11));
      state                  : OUT    std_logic_vector (3 DOWNTO 0);
      wiz_number_of_channels : OUT    std_logic_vector (3 DOWNTO 0)                    := (others => '0');
      wiz_ram_start_addr     : OUT    std_logic_vector (RAM_ADDR_WIDTH_16B-1 DOWNTO 0) := (others => '0');
      wiz_write_ea           : OUT    std_logic                                        := '0';
      wiz_write_end          : OUT    std_logic                                        := '0';
      wiz_write_header       : OUT    std_logic                                        := '0';
      wiz_write_length       : OUT    std_logic_vector (16 DOWNTO 0)                   := (others => '0')
   );
   END COMPONENT;
   COMPONENT spi_interface
   PORT (
      clk_50MHz         : IN     std_logic ;
      config_start      : IN     std_logic ;
      dac_array         : IN     dac_array_type ;
      sclk_enable_i     : IN     std_logic ;
      config_ready      : OUT    std_logic ;
      current_dac_array : OUT    dac_array_type  := ( others => 0);
      dac_cs            : OUT    std_logic ;
      mosi              : OUT    std_logic       := '0';
      sclk              : OUT    std_logic ;
      sensor_array      : OUT    sensor_array_type ;
      sensor_cs         : OUT    std_logic_vector (3 DOWNTO 0);
      sensor_ready      : OUT    std_logic ;
      miso              : INOUT  std_logic 
   );
   END COMPONENT;
   COMPONENT timer
   GENERIC (
      TIMER_WIDTH : integer := 32;
      PRESCALER   : integer := 5000
   );
   PORT (
      clk           : IN     std_logic;
      enable_i      : IN     std_logic;
      reset_synch_i : IN     std_logic;
      synch_i       : IN     std_logic;
      synched_o     : OUT    std_logic  := '0';
      time_o        : OUT    std_logic_vector ( TIMER_WIDTH-1 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT trigger_counter
   PORT (
      trigger_id : OUT    std_logic_vector (31 DOWNTO 0);
      trigger    : IN     std_logic ;
      reset      : IN     std_logic ;
      clk        : IN     std_logic 
   );
   END COMPONENT;
   COMPONENT trigger_manager
   PORT (
      clk                   : IN     std_logic;
      drs_readout_ready     : IN     std_logic;
      trigger_in            : IN     std_logic;
      drs_readout_ready_ack : OUT    std_logic  := '0';
      drs_write             : OUT    std_logic  := '1';
      trigger_out           : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT w5300_modul
   GENERIC (
      RAM_ADDR_WIDTH : integer := 14
   );
   PORT (
      state                         : OUT    std_logic_vector (7 DOWNTO 0);                                  -- state is encoded here ... useful for debugging.
      debug_data_ram_empty          : OUT    std_logic ;
      debug_data_valid              : OUT    std_logic ;
      data_generator_idle_i         : IN     std_logic ;
      socket_tx_free_out            : OUT    std_logic_vector (16 DOWNTO 0);                                 -- 17bit value .. that's true
      clk                           : IN     std_logic ;
      wiz_reset                     : OUT    std_logic                      := '1';
      addr                          : OUT    std_logic_vector (9 DOWNTO 0);
      data                          : INOUT  std_logic_vector (15 DOWNTO 0);
      cs                            : OUT    std_logic                      := '1';
      wr                            : OUT    std_logic                      := '1';
      led                           : OUT    std_logic_vector (7 DOWNTO 0)  := (OTHERS => '0');
      rd                            : OUT    std_logic                      := '1';
      int                           : IN     std_logic ;
      write_length                  : IN     std_logic_vector (16 DOWNTO 0);
      ram_start_addr                : IN     std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      ram_data                      : IN     std_logic_vector (15 DOWNTO 0);
      ram_addr                      : OUT    std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      data_valid                    : IN     std_logic ;
      data_valid_ack                : OUT    std_logic                      := '0';
      busy                          : OUT    std_logic                      := '1';
      write_header_flag             : IN     std_logic ;
      write_end_flag                : IN     std_logic ;
      fifo_channels                 : IN     std_logic_vector (3 DOWNTO 0);
      -- softtrigger:
      s_trigger                     : OUT    std_logic                      := '0';
      c_trigger_enable              : OUT    std_logic                      := '0';
      c_trigger_mult                : OUT    std_logic_vector (15 DOWNTO 0) := conv_std_logic_vector(0 ,16); --subject TO changes
      -- FAD configuration signals:
      ------------------------------------------------------------------------------
      memory_manager_config_start_o : OUT    std_logic                      := '0';
      memory_manager_config_valid_i : IN     std_logic ;
      spi_interface_config_start_o  : OUT    std_logic                      := '0';
      spi_interface_config_valid_i  : IN     std_logic ;
      --data_generator_config_start_o	: out std_logic := '0';
      --data_generator_config_valid_i	: in std_logic;
      dac_setting                   : OUT    dac_array_type                 := DEFAULT_DAC;                  --<<-- default defined in fad_definitions.vhd
      roi_setting                   : OUT    roi_array_type                 := DEFAULT_ROI;                  --<<-- default defined in fad_definitions.vhd
      runnumber                     : OUT    std_logic_vector (31 DOWNTO 0) := conv_std_logic_vector(0 ,32);
      reset_trigger_id              : OUT    std_logic                      := '0';
      data_ram_empty                : IN     std_logic ;
      ------------------------------------------------------------------------------
      
      -- MAC/IP calculation signals:
      ------------------------------------------------------------------------------
      MAC_jumper                    : IN     std_logic_vector (1 DOWNTO 0);
      BoardID                       : IN     std_logic_vector (3 DOWNTO 0);
      CrateID                       : IN     std_logic_vector (1 DOWNTO 0);
      ------------------------------------------------------------------------------
      
      -- user controllable enable signals
      ------------------------------------------------------------------------------
      trigger_enable                : OUT    std_logic ;
      denable                       : OUT    std_logic                      := '0';                          -- default domino wave on. ... in case if REFCLK error ... REFCLK counter will override.
      dwrite_enable                 : OUT    std_logic                      := '1';                          -- default DWRITE low.
      sclk_enable                   : OUT    std_logic                      := '1';                          -- default DWRITE HIGH.
      srclk_enable                  : OUT    std_logic                      := '1';                          -- default SRCLK on.
      busy_enable                   : OUT    std_logic                      := '1';
      socket_send_mode_out          : OUT    std_logic ;
      ------------------------------------------------------------------------------
      
      -- ADC CLK generator, is able to shift phase with respect to X_50M
      -- these signals control the behavior of the digital clock manager (DCM)
      ------------------------------------------------------------------------------
      ps_direction                  : OUT    std_logic                      := '1';                          -- default phase shift upwards
      ps_do_phase_shift             : OUT    std_logic                      := '0';                          --pulse this TO phase shift once
      ps_reset                      : OUT    std_logic                      := '0';                          -- pulse this TO reset the variable phase shift
      ps_ready                      : IN     std_logic ;
      ------------------------------------------------------------------------------
      
      -- signals used to control FAD LED bahavior:
      -- one of the three LEDs is used for com-status info
      ------------------------------------------------------------------------------
      socks_waiting                 : OUT    std_logic ;
      socks_connected               : OUT    std_logic 
      ------------------------------------------------------------------------------
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_rs485_receiver USE ENTITY FACT_FAD_lib.FAD_rs485_receiver;
   FOR ALL : REFCLK_counter USE ENTITY FACT_FAD_lib.REFCLK_counter;
   FOR ALL : adc_buffer USE ENTITY FACT_FAD_lib.adc_buffer;
   FOR ALL : clock_generator_var_ps USE ENTITY FACT_FAD_lib.clock_generator_var_ps;
   FOR ALL : continous_pulser USE ENTITY FACT_FAD_lib.continous_pulser;
   FOR ALL : dataRAM_64b_16b_width14_5 USE ENTITY FACT_FAD_lib.dataRAM_64b_16b_width14_5;
   FOR ALL : data_generator USE ENTITY FACT_FAD_lib.data_generator;
   FOR ALL : dna_gen USE ENTITY FACT_FAD_lib.dna_gen;
   FOR ALL : drs_pulser USE ENTITY FACT_FAD_lib.drs_pulser;
   FOR ALL : led_controller USE ENTITY FACT_FAD_lib.led_controller;
   FOR ALL : memory_manager_2 USE ENTITY FACT_FAD_lib.memory_manager_2;
   FOR ALL : spi_interface USE ENTITY FACT_FAD_lib.spi_interface;
   FOR ALL : timer USE ENTITY FACT_FAD_lib.timer;
   FOR ALL : trigger_counter USE ENTITY FACT_FAD_lib.trigger_counter;
   FOR ALL : trigger_manager USE ENTITY FACT_FAD_lib.trigger_manager;
   FOR ALL : w5300_modul USE ENTITY FACT_FAD_lib.w5300_modul;
   -- pragma synthesis_on


BEGIN

   -- ModuleWare code(v1.9) for instance 'I6' of 'and'
   SRCLK <= SRCLK1 AND srclk_enable;

   -- ModuleWare code(v1.9) for instance 'U_1' of 'and'
   dout <= dout0 AND dout1 AND dout2 AND dout3;

   -- ModuleWare code(v1.9) for instance 'U_4' of 'and'
   dwrite_global_enable <= dwrite_enable_w5300 AND dout4;

   -- ModuleWare code(v1.9) for instance 'and_1' of 'and'
   ADC_CLK <= adc_clk_en AND CLK_25_PS_internal;

   -- ModuleWare code(v1.9) for instance 'and_2' of 'and'
   denable_sig <= denable_prim AND din1;

   -- ModuleWare code(v1.9) for instance 'and_4' of 'and'
   dout6 <= trigger_or_s_trigger AND trigger_enable;

   -- ModuleWare code(v1.9) for instance 'and_5' of 'and'
   drs_dwrite <= dwrite_trigger_manager AND dwrite_global_enable;

   -- ModuleWare code(v1.9) for instance 'and_6' of 'and'
   trig_veto <= busy_enable AND dout7;

   -- ModuleWare code(v1.9) for instance 'U_5' of 'assignment'
   denable <= denable_sig;

   -- ModuleWare code(v1.9) for instance 'U_7' of 'assignment'
   trigger_veto <= trig_veto;

   -- ModuleWare code(v1.9) for instance 'U_8' of 'assignment'
   wiz_reset <= wiz_reset_sig;

   -- ModuleWare code(v1.9) for instance 'U_6' of 'gnd'
   software_trigger_in <= '0';

   -- ModuleWare code(v1.9) for instance 'U_15' of 'gnd'
   reset_synch_i <= '0';

   -- ModuleWare code(v1.9) for instance 'inverter_1' of 'inv'
   din1 <= NOT(alarm_refclk_too_low_internal);

   -- ModuleWare code(v1.9) for instance 'inverter_2' of 'inv'
   dout5 <= NOT(ram_write_ea);

   -- ModuleWare code(v1.9) for instance 'U_2' of 'or'
   dout4 <= dout OR I_really_want_dwrite;

   -- ModuleWare code(v1.9) for instance 'or_2' of 'or'
   dout7 <= trigger_veto1 OR dout5;

   -- ModuleWare code(v1.9) for instance 'or_5' of 'or'
   trigger_or_s_trigger <= cont_trigger OR trigger;

   -- ModuleWare code(v1.9) for instance 'or_6' of 'or'
   enabled_trigger_or_s_trigger <= s_trigger OR dout6;

   -- ModuleWare code(v1.9) for instance 'U_0' of 'split'
   mw_U_0temp_din <= plllock_in;
   u_0combo_proc: PROCESS (mw_U_0temp_din)
   VARIABLE temp_din: std_logic_vector(3 DOWNTO 0);
   BEGIN
      temp_din := mw_U_0temp_din(3 DOWNTO 0);
      dout0 <= temp_din(0);
      dout1 <= temp_din(1);
      dout2 <= temp_din(2);
      dout3 <= temp_din(3);
   END PROCESS u_0combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_3' of 'vdd'
   I_really_want_dwrite <= '1';

   -- ModuleWare code(v1.9) for instance 'U_14' of 'vdd'
   enable_i <= '1';

   -- Instance port mappings.
   Inst_rs485_receiver : FAD_rs485_receiver
      GENERIC MAP (
         RX_BYTES => RS485_MESSAGE_LEN_BYTES,            -- no. of bytes to receive
         RX_WIDTH => RS485_MESSAGE_LEN_BYTES * 8         -- no. of bits to receive
      )
      PORT MAP (
         rec_clk             => CLK_50_internal,
         rx_d                => FTM_RS485_rx_d,
         rx_en               => FTM_RS485_rx_en,
         tx_d                => FTM_RS485_tx_d,
         tx_en               => FTM_RS485_tx_en,
         rec_start           => drs_readout_started,
         rec_timeout_occured => rec_timeout_occured,
         rec_dout            => rs465_data,
         rec_valid           => FTM_RS485_ready
      );
   REFCLK_counter_main : REFCLK_counter
      PORT MAP (
         clk                   => CLK_50_internal,
         refclk_in             => drs_refclk_in,
         counter_result        => counter_result_internal,
         alarm_refclk_too_high => alarm_refclk_too_high_internal,
         alarm_refclk_too_low  => alarm_refclk_too_low_internal
      );
   I_main_adc_buffer : adc_buffer
      PORT MAP (
         clk_ps             => CLK_25_PS_internal,
         adc_data_array     => adc_data_array,
         adc_otr_array      => adc_otr_array,
         adc_data_array_int => adc_data_array_int,
         adc_otr            => adc_otr
      );
   clock_generator_instance : clock_generator_var_ps
      PORT MAP (
         CLK             => CLK,
         RST_IN          => ps_reset,
         direction       => ps_direction,
         do_shift        => ps_do_phase_shift,
         CLK_25          => CLK_25,
         CLK_25_PS       => CLK_25_PS_internal,
         CLK_50          => CLK_50_internal,
         locked_status_o => DCM_locked_status,
         offset          => DCM_PS_status,
         ready_status_o  => DCM_ready_status
      );
   continous_pulser_instance : continous_pulser
      GENERIC MAP (
         MINIMAL_TRIGGER_WAIT_TIME => 25000,
         TRIGGER_WIDTH             => 5
      )
      PORT MAP (
         CLK        => CLK_25,
         enable     => c_trigger_enable,
         multiplier => c_trigger_mult,
         trigger    => cont_trigger
      );
   dataRAM_instance : dataRAM_64b_16b_width14_5
      PORT MAP (
         clka  => CLK_25,
         dina  => data_out,
         addra => addr_out,
         wea   => write_ea,
         clkb  => CLK_50_internal,
         addrb => ram_addr,
         doutb => ram_data
      );
   I_main_data_generator : data_generator
      GENERIC MAP (
         RAM_ADDR_WIDTH => RAMADDRWIDTH64b
      )
      PORT MAP (
         state                      => DG_state,
         is_idle                    => is_idle,
         clk                        => CLK_25,
         data_out                   => data_out,
         addr_out                   => addr_out,
         dataRAM_write_ea_o         => write_ea,
         ram_start_addr             => ram_start_addr,
         ram_write_ea               => ram_write_ea,
         ram_write_ready            => ram_write_ready,
         roi_array                  => roi_setting,
         roi_max                    => roi_max,
         sensor_array               => sensor_array,
         sensor_ready               => sensor_ready,
         dac_array                  => current_dac_array,
         config_start               => dg_start_config,
         config_done                => dg_config_done,
         package_length             => package_length,
         pll_lock                   => plllock_in,
         dwrite_enable_in           => dwrite_enable_w5300,
         denable_enable_in          => denable_sig,
         busy_enable_in             => busy_enable,
         trigger_enable_in          => trigger_enable,
         cont_trigger_en_in         => c_trigger_enable,
         socket_send_mode_in        => socket_send_mode,
         FTM_RS485_ready            => FTM_RS485_ready,
         FTM_trigger_info           => rs465_data,
         FTM_receiver_status        => rec_timeout_occured,
         fad_event_counter          => trigger_id,
         refclk_counter             => counter_result_internal,
         refclk_too_high            => alarm_refclk_too_high_internal,
         refclk_too_low             => alarm_refclk_too_low_internal,
         board_id                   => board_id,
         crate_id                   => crate_id,
         DCM_PS_status              => DCM_PS_status,
         DCM_locked_status          => DCM_locked_status,
         DCM_ready_status           => DCM_ready_status,
         SPI_SCLK_enable_status     => sclk_enable,
         TRG_GEN_div                => c_trigger_mult,
         dna                        => dna,
         runnumber                  => runnumber,
         timer_value                => time,
         hardware_trigger_in        => trigger_out,
         software_trigger_in        => software_trigger_in,
         adc_data_array             => adc_data_array_int,
         adc_output_enable_inverted => adc_oeb,
         adc_clk_en                 => adc_clk_en,
         adc_otr                    => adc_otr,
         drs_channel_id             => drs_channel_id,
         drs_readout_ready          => drs_readout_ready,
         drs_readout_ready_ack      => drs_readout_ready_ack,
         drs_clk_en                 => drs_clk_en,
         start_read_drs_stop_cell   => drs_read_s_cell,
         drs_srin_write_8b          => start_srin_write_8b,
         drs_srin_write_ack         => srin_write_ack,
         drs_srin_data              => drs_srin_data,
         drs_srin_write_ready       => srin_write_ready,
         drs_read_s_cell_ready      => drs_read_s_cell_ready,
         drs_s_cell_array           => drs_s_cell_array,
         drs_readout_started        => drs_readout_started,
         trigger_veto               => trigger_veto1
      );
   dna_gen_instance : dna_gen
      PORT MAP (
         clk   => CLK_25,
         dna   => dna,
         ready => ready
      );
   I_main_drs_pulser : drs_pulser
      PORT MAP (
         CLK                      => CLK_25,
         start_endless_mode       => drs_clk_en,
         start_read_stop_pos_mode => drs_read_s_cell,
         SROUT_in_0               => SROUT_in_0,
         SROUT_in_1               => SROUT_in_1,
         SROUT_in_2               => SROUT_in_2,
         SROUT_in_3               => SROUT_in_3,
         stop_pos                 => drs_s_cell_array,
         stop_pos_valid           => drs_read_s_cell_ready,
         start_srin_write_8b      => start_srin_write_8b,
         srin_write_ready         => srin_write_ready,
         srin_write_ack           => srin_write_ack,
         srin_data                => drs_srin_data,
         SRIN_out                 => SRIN_out,
         RSRLOAD                  => RSRLOAD,
         SRCLK                    => SRCLK1
      );
   led_controller_instance : led_controller
      GENERIC MAP (
         HEARTBEAT_PWM_DIVIDER => 50000,
         WAITING_DIVIDER       => 50000000
      )
      PORT MAP (
         CLK                    => CLK_50_internal,
         green                  => green,
         amber                  => amber,
         red                    => red,
         additional_flasher_out => OPEN,
         trigger                => drs_readout_started,
         w5300_reset            => wiz_reset_sig,
         trigger_veto           => trig_veto,
         refclk_too_high        => alarm_refclk_too_high_internal,
         refclk_too_low         => alarm_refclk_too_low_internal,
         socks_waiting          => socks_waiting,
         socks_connected        => socks_connected
      );
   Inst_memory_manager_2 : memory_manager_2
      GENERIC MAP (
         RAM_ADDR_WIDTH_64B => RAMADDRWIDTH64b,
         RAM_ADDR_WIDTH_16B => RAMADDRWIDTH64b+2
      )
      PORT MAP (
         state                  => mem_manager_state,
         clk                    => CLK_25,
         config_start           => memory_manager_config_start,
         config_ready           => memory_manager_config_valid,
         roi_array              => roi_setting,
         roi_max                => roi_max,
         package_length         => package_length,
         wiz_number_of_channels => wiz_number_of_channels,
         dg_start_config        => dg_start_config,
         dg_config_done         => dg_config_done,
         ram_write_ready        => ram_write_ready,
         ram_write_ea           => ram_write_ea,
         ram_start_addr         => ram_start_addr,
         wiz_read_done          => data_valid_ack,
         wiz_write_ea           => wiz_write_ea,
         wiz_write_length       => wiz_write_length,
         wiz_ram_start_addr     => wiz_ram_start_addr,
         wiz_write_header       => wiz_write_header,
         wiz_write_end          => wiz_write_end,
         data_ram_empty         => data_ram_empty
      );
   I_main_SPI_interface : spi_interface
      PORT MAP (
         clk_50MHz         => CLK_50_internal,
         config_start      => spi_interface_config_start,
         dac_array         => dac_setting,
         sclk_enable_i     => sclk_enable,
         config_ready      => spi_interface_config_valid,
         current_dac_array => current_dac_array,
         dac_cs            => dac_cs,
         mosi              => mosi,
         sclk              => sclk,
         sensor_array      => sensor_array,
         sensor_cs         => sensor_cs,
         sensor_ready      => sensor_ready,
         miso              => sio
      );
   timer_instance : timer
      GENERIC MAP (
         TIMER_WIDTH => 32,
         PRESCALER   => 5000
      )
      PORT MAP (
         clk           => CLK_50_internal,
         time_o        => time,
         synch_i       => trigger_out,
         synched_o     => OPEN,
         reset_synch_i => reset_synch_i,
         enable_i      => enable_i
      );
   trigger_counter_instance : trigger_counter
      PORT MAP (
         trigger_id => trigger_id,
         trigger    => trigger_out,
         reset      => reset_trigger_id,
         clk        => CLK_25_PS_internal
      );
   trigger_manager_instance : trigger_manager
      PORT MAP (
         clk                   => CLK_25,
         trigger_in            => enabled_trigger_or_s_trigger,
         trigger_out           => trigger_out,
         drs_write             => dwrite_trigger_manager,
         drs_readout_ready     => drs_readout_ready,
         drs_readout_ready_ack => drs_readout_ready_ack
      );
   w5300_modul_instance : w5300_modul
      GENERIC MAP (
         RAM_ADDR_WIDTH => RAMADDRWIDTH64b+2
      )
      PORT MAP (
         state                         => w5300_state,
         debug_data_ram_empty          => debug_data_ram_empty,
         debug_data_valid              => debug_data_valid,
         data_generator_idle_i         => is_idle,
         socket_tx_free_out            => socket_tx_free_out,
         clk                           => CLK_50_internal,
         wiz_reset                     => wiz_reset_sig,
         addr                          => wiz_addr,
         data                          => wiz_data,
         cs                            => wiz_cs,
         wr                            => wiz_wr,
         led                           => led,
         rd                            => wiz_rd,
         int                           => wiz_int,
         write_length                  => wiz_write_length,
         ram_start_addr                => wiz_ram_start_addr,
         ram_data                      => ram_data,
         ram_addr                      => ram_addr,
         data_valid                    => wiz_write_ea,
         data_valid_ack                => data_valid_ack,
         busy                          => OPEN,
         write_header_flag             => wiz_write_header,
         write_end_flag                => wiz_write_end,
         fifo_channels                 => wiz_number_of_channels,
         s_trigger                     => s_trigger,
         c_trigger_enable              => c_trigger_enable,
         c_trigger_mult                => c_trigger_mult,
         memory_manager_config_start_o => memory_manager_config_start,
         memory_manager_config_valid_i => memory_manager_config_valid,
         spi_interface_config_start_o  => spi_interface_config_start,
         spi_interface_config_valid_i  => spi_interface_config_valid,
         dac_setting                   => dac_setting,
         roi_setting                   => roi_setting,
         runnumber                     => runnumber,
         reset_trigger_id              => reset_trigger_id,
         data_ram_empty                => data_ram_empty,
         MAC_jumper                    => D_T_in,
         BoardID                       => board_id,
         CrateID                       => crate_id,
         trigger_enable                => trigger_enable,
         denable                       => denable_prim,
         dwrite_enable                 => dwrite_enable_w5300,
         sclk_enable                   => sclk_enable,
         srclk_enable                  => srclk_enable,
         busy_enable                   => busy_enable,
         socket_send_mode_out          => socket_send_mode,
         ps_direction                  => ps_direction,
         ps_do_phase_shift             => ps_do_phase_shift,
         ps_reset                      => ps_reset,
         ps_ready                      => DCM_ready_status,
         socks_waiting                 => socks_waiting,
         socks_connected               => socks_connected
      );

   -- Implicit buffered output assignments
   CLK_25_PS             <= CLK_25_PS_internal;
   CLK_50                <= CLK_50_internal;
   alarm_refclk_too_high <= alarm_refclk_too_high_internal;
   alarm_refclk_too_low  <= alarm_refclk_too_low_internal;
   counter_result        <= counter_result_internal;

END struct;
