//
//  FADctrl
//

#include <stdio.h>
#include <readline/history.h>
#include <string>

#include "FAD.h"

using namespace std;

const string READLINE_HIST_FILE = string(getenv("HOME"))+"/.history_FADctrl";

// ================
//   Main program
// ================

int main(int argc, char *argv[]) {

  std::vector<std::string> List;
  
  // Board list from command line?
  for (int i=1; i<argc; i++) List.push_back(argv[i]);
  
  // Uses getc() for readline library (allows interruption by signal) and load history buffer
  rl_getc_function = getc;
  read_history(READLINE_HIST_FILE.c_str());

  if (system("clear") == -1) {
	printf("Error with system() call\n");
  }
  printf("\n*** FADctrl (built %s, %s, revision %s) *** \n\n",__DATE__, __TIME__, REVISION);

  // Construct main instance (static ensures destructor is called with exit())
  static class FAD M(List);

  // Do not kill process if writing to closed socket
  signal(SIGPIPE, SIG_IGN);

  // Command loop
  char *Command;
  std::string LastHist;

  while (!M.ExitRequest) {
    Command = readline("FADctrl> ");
	
	// Check for interruption by signal
    if (Command == NULL) continue;

	// Add command to history
    if(strlen(Command) > 0 && LastHist != Command) {
	  add_history(Command);
	  LastHist = Command;
	}

    // Process command (use SendCommandNB(), see mail from C. Gaspar 18/2/2011)
	DimClient::sendCommandNB(SERVER_NAME"/Command", Command);
    free(Command);
  }
  
  // Save history buffer  
  int Ret = write_history(READLINE_HIST_FILE.c_str());
  if (Ret != 0 ) printf("Error writing history file to '%s' (%s)\n", READLINE_HIST_FILE.c_str(), strerror(Ret));
}
