// **************************************************************************
/** @file tools.cc

@todo
   - Resolve the dependancies with dim
   - Move code to a more appropriate place
   - put stuff in namespaces
*/
// **************************************************************************
#include "tools.h"

#include <stdarg.h>

#include <boost/filesystem.hpp>

using namespace std;
/*
string Tools::Format(const char *fmt, va_list &ap)
{
    int n=256;

    char *ret=0;
    while (1)
    {
        ret = new char[n+1];

        const int sz = vsnprintf(ret, n, fmt, ap);
        if (sz<=n)
            break;

        n *= 2;
        delete [] ret;
    };

    string str(ret);

    delete [] ret;

    return str;
}

string Tools::Form(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    string str = Format(fmt, ap);

    va_end(ap);

    return str;
}
*/

// --------------------------------------------------------------------------
//
//! This is a static helper to remove leading and trailing whitespaces.
//!
//! @param str
//!    a pointer to the char array from which the whitespaces should be
//!    removed
//!
//! @returns
//!    a std::string with the whitespaces removed from buf
//
string Tools::Trim(const string &str)
{
    // Trim Both leading and trailing spaces
    const size_t start = str.find_first_not_of(' '); // Find the first character position after excluding leading blank spaces
    const size_t end   = str.find_last_not_of(' ');  // Find the first character position from reverse af

    // if all spaces or empty return an empty string
    if (string::npos==start || string::npos==end)
        return string();

    return str.substr(start, end-start+1);
}

// --------------------------------------------------------------------------
//
//! Splits a string of the form [SERVER/]COMMAND[ arguments]
//! into SERVER, COMMAND and arguments.
//!
//! @param str
//!    string to be splitted
//!
//! @returns
//!    a vector<string> with three components. Depending on what is existing
//!    in the string some of the components might be empty.
//!
/*
vector<string> Split(std::string str)
{
    const size_t p0 = str.find_first_of('/');

    size_t p1 = str.find_first_of(' ');

    vector<string> v(3);

    // string starts with SERVER/COMMAND[ arguments]
    if (p0<p1)
    {
        // SERVER
        v[0] = str.substr(0, p0);

        // COMMAND[ arguments)
        str = str.substr(p0+1);
        p1  = str.find_first_of(' ');
    }

    // String is of the form: COMMAND[ arguments]

    // COMMAND
    v[1] = str.substr(0, p1);

    // Has arguments
    if (p1!=string::npos)
        v[2] = str.substr(p1+1);

    return v;
}
*/
