//*************************************************************************************
/** @class FilesStatisticsService
 *
 * @brief provides a statistics service telling the free space on disk and the total size written so far
 *
 */
//*************************************************************************************
#ifndef FILESSTATISTICSSERVICE_H_
#define FILESSTATISTICSSERVICE_H_

#include "MessageDim.h"
#include <boost/thread.hpp>
#include <mutex>
#include <string>
#include <set>

using namespace std;

struct FileStatisticsData {
    long sizeWritten;
    long freeSpace;
    long writingRate;
};
class FilesStatisticsService
{
private:
    string fServerName;
    string fCurrentFolder;
    boost::thread fThread;
    FileStatisticsData fStats;
    mutex fMutex;
    DimDescribedService* fService;
    bool fContinueStats;
    bool fDebug;
    void UpdateService();
    long GetFreeSpace();
    long GetFileSizeOnDisk(const string& file);
    long fBaseSize;
    set<string> fOpenedFiles;
    float fPeriodDuration;
    MessageImp* fMess;
public:
    ///Default constructor
//    FilesStatisticsService();
    FilesStatisticsService(const string& serverName, MessageImp* mess);
    ///Default destructor
    ~FilesStatisticsService();
    ///Configures that current folder where files are written to
    bool SetCurrentFolder(string& folder);
    bool FileOpened(const string& fileName);
    void SetDebugMode(bool);
    void SetStatPeriod(float duration);
    void GetTotalSizeWritten(FileStatisticsData& data);
    void Reset();
};

#endif /* FILESSTATISTICSSERVICE_H_ */
