//*************************************************************************************
/** @class FilesStatisticsService
 *
 * @brief provides a statistics service telling the free space on disk and the total size written so far
 *
 */
//*************************************************************************************
#ifndef FILESSTATISTICSSERVICE_H_
#define FILESSTATISTICSSERVICE_H_

#include "MessageDim.h"
#include <boost/thread.hpp>
#include <mutex>
#include <string>
#include <set>

using namespace std;

struct FileStatisticsData {
    long sizeWritten;
    long freeSpace;
    long writingRate;
};
class FilesStatisticsService
{
private:
    ///The name of the server which created the object
    string fServerName;
    ///The current folder being watched for free space
    string fCurrentFolder;
    ///The boost thread used to update the service
    boost::thread fThread;
    ///The data structure holding the stat data
    FileStatisticsData fStats;
    ///The mutex used to make sure that the service isn't updated while changing conf.
    mutex fMutex;
    ///the Dim service
    DimDescribedService* fService;
    ///Bool indicating if main loop should be exited
    bool fContinueStats;
    ///Bool indicating if debug information should be printed
    bool fDebug;
    ///Main loop
    void UpdateService();
    ///Returns the free space on the disk of the folder being watched (fCurrentFolder)
    long GetFreeSpace();
    ///Returns the size on disk of a given file
    long GetFileSizeOnDisk(const string& file);
    ///This is the total base size of all opened files
    long fBaseSize;
    ///This is the list of all opened files. set is used to easily check for entries
    set<string> fOpenedFiles;
    ///This is the duration, in second between two service updates. 0 means no more updates
    float fPeriodDuration;
    ///This is the MessageImp object used for messaging
    MessageImp* fMess;
public:
    ///Constructor
    FilesStatisticsService(const string& serverName, MessageImp* mess);
    ///Default destructor
    ~FilesStatisticsService();
    ///Configures that current folder where files are written to
    bool SetCurrentFolder(const string& folder);
    bool FileOpened(const string& fileName);
    void SetDebugMode(bool);
    void SetStatPeriod(const float duration);
    void GetTotalSizeWritten(FileStatisticsData& data);
    void Reset();
};

#endif /* FILESSTATISTICSSERVICE_H_ */
