#ifndef HV_H_SEEN
#define HV_H_SEEN

#include <termios.h>		// POSIX terminal control definitions
#include <fcntl.h>		// File control definitions => fcntl() in fcn OpenPort()
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <string>
#include <vector>
#include <map>

#include "dis.hxx"

#define MAX_NUM_BOARDS 13	// Maximum number of boards per crate
#define NUM_CHANNELS 32		// Channels per bias board
#define BAUDRATE B115200
const float RESISTOR = 1000;	// Resistance in Ohm for voltage correction
const int MAX_ERR_COUNT = 10;	// Maximum number of errors before reporting stopped
class User;

class Crate {
  
    class User *m;
	int CrateNumber;
	int fDescriptor;
	FILE *File;
	DimService *NameService;
	DimService *BiasVolt;
	DimService *BiasDAC;
	DimService *BiasCurrent;


	int DAC[MAX_NUM_BOARDS][NUM_CHANNELS];		// Voltage in DAC units
	double Volt[MAX_NUM_BOARDS][NUM_CHANNELS];	// Voltage in Volt
	float Current[MAX_NUM_BOARDS][NUM_CHANNELS];
	std::vector<unsigned char> Communicate(std::string);
	void ClearVoltageArrays();
   
  public:
    Crate(std::string, int, class User *);
    ~Crate();

    char *Name;

	bool OC[MAX_NUM_BOARDS][NUM_CHANNELS];
	bool Present[MAX_NUM_BOARDS][NUM_CHANNELS];
	bool ResetHit;
	bool WrapOK;
	int WrapCount;
	int ErrorCount;

	float RefCurrent[MAX_NUM_BOARDS][NUM_CHANNELS];
	double RefVolt[MAX_NUM_BOARDS][NUM_CHANNELS];

	bool InitOK;

	int SetChannels(std::map<unsigned int, double>);
	int ReadAll();
	int SystemReset();
	int GlobalSet(double);
	bool Synch();
	double GetVoltage(unsigned int);
	unsigned int GetDAC(unsigned int);
	float GetCurrent(unsigned int);
	void UpdateDIM();
	void SetRefCurrent();
	void AdaptVoltages();
};

#endif
