
#ifndef PROCESSIO_H_SEEN
#define PROCESSIO_H_SEEN

#include <stdarg.h>
#include <errno.h>
#include <math.h>
#include <signal.h>
#include <string>
#include <pthread.h>
#include <limits>

#define SERVER_NAME "Bias"       // Name to use in DIM
#include "Evidence.h"

#include "Crate.h"
#include "../pixelmap/PixelMap.h"

#define MAX_COM_SIZE 5000

#define MIN_RATE 0.01
#define MAX_RATE 50.0

class User: public EvidenceServer {

	enum RunMode {mode_static, mode_dynamic};

	PixelMap *PixMap;
	DimCommand *DIMCommand;
	DimService *ConsoleOut;
	char *ConsoleText;
	pthread_t MainThread, Thread;
	std::vector<std::string> Parameter;
	RunMode Mode;

	std::vector<class Crate *> Crates;
	std::vector<double> DefaultVoltage;

	void commandHandler();

	struct Range {
	  int Min;
	  int Max;
	};

	bool Match(std::string, const char *);
	bool ConvertToDouble(std::string, double *);
	bool ConvertToInt(std::string, int *);
	bool ConvertToRange(std::string, struct Range &);

 public:
	double fTimeOut;
	float fStatusRefreshRate;
	double fMaxDiff;
	int ActiveCrate;

	User();
	~User();

	void PrintMessage(const char *, ...);
	unsigned int RampVoltages(int, std::map<unsigned int, double>);
	void Monitor();
	static void LaunchMonitor(User *);
	
	void cmd_hv();		void cmd_synch();
	void cmd_status();	void cmd_gs();
	void cmd_load();	void cmd_save();
	void cmd_exit();	void cmd_rate();
	void cmd_timeout();	void cmd_reset();
	void cmd_help();	void cmd_mode();
	void cmd_crate();
};

#endif
