//
// Program for testing bias cabling
//
//

#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>

#include "dic.hxx"

// Get configuration data
int main(int argc, const char* argv[]) {

  int Quadrant, Cable, Connector, Channel;
  char Command[100];

  if (argc != 4) {
    printf("Usage: %s <quadrant> <cable> <connector>\n", argv[0]);
    exit(EXIT_FAILURE);
  }

  Quadrant = atoi(argv[1]);
  Cable = atoi(argv[2]);
  Connector = atoi(argv[3]);
  
  if (Quadrant<0 || Quadrant>3 || Cable<0 || Cable>9 || Connector<0 || Connector>3) {
    printf("Quadrant, cable or connector number out of range\n");
    exit(EXIT_FAILURE);
  }
  
  if (Quadrant==0 || Quadrant==2) Channel = Quadrant*80+Cable*8+Connector*2;
  else {
    if (Cable==8 || Cable==9) Channel = Quadrant*80+(Cable-8)*8+Connector*2;
    if (Cable>=4 && Cable<=7) Channel = Quadrant*80+(Cable-2)*8+Connector*2;
    if (Cable>=0 && Cable<=3) Channel = Quadrant*80+(Cable+6)*8+Connector*2;
  }

  // Switch off all channel
  DimClient::sendCommand("Bias/Command", "gs 0");

  // Switch on 4-fold patch
  snprintf(Command, sizeof(Command), "channel %d 70", Channel);     
  DimClient::sendCommand("Bias/Command", Command);
  printf("Switched on channel %d\n", Channel);
  sleep(2);

  // Switch on 5-fold patch
  Channel++;
  snprintf(Command, sizeof(Command), "channel %d 70", Channel);     
  DimClient::sendCommand("Bias/Command", Command);
  printf("Switched on channel %d\n", Channel);
  sleep(2);
  
  // Switch of all channels
  DimClient::sendCommand("Bias/Command", "gs 0");
  printf("Switched off all channels\n");
  
  exit(EXIT_SUCCESS);

}
