#ifndef DAQREADOUT_H_SEEN
#define DAQREADOUT_H_SEEN

#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <sys/socket.h>
#include <pthread.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/vfs.h>
#include <signal.h>

#include "RawDataCTX.h"
#include "DRS.h"
#include "HVFeedback.h"

#define RUN_NUM_FILE "/ct3data/LastRunNumber"

#define MAX_PATH 256		// also used for filename length
#define MAX_COM_SIZE 10000
#define MAX_NUM_TOKEN 10

#define MsgToConsole 1
#define MsgToLog 2
#define MsgToSocket 4

enum state_enum {active, stopped};
enum runtype_enum {data, pedestal, reserved, test};

class DAQReadout {
    time_t StartTime;

    pthread_t thread_DAQ;
    pthread_t thread_DAQ_Silent;

    unsigned int CmdNumber;
    FILE *Logfile;    
    void PrintUsage();
    bool CalibrationRead;
	
  public:
    RunHeader*   RHeader;
    EventHeader* EHeader;
    
    DRS *drs;

    short (*WaveForm)[kNumberOfChips][kNumberOfChannels][kNumberOfBins];
    int (*TriggerCell)[kNumberOfChips];

    pthread_mutex_t control_mutex;
    int Rawfile;
    class HVFeedback* HVFB;
    class SlowData *SlowDataClass; 

    // Configuration data
    char fLogFile[MAX_PATH];
    char fSlowDataPath[MAX_PATH];
    unsigned int fMaxLogLines;
    char fRawDataPath[MAX_PATH];
    int fMinDiskSpaceMB;   // Minimum required disk space in MBytes
    int fMaxFileSizeMB;    // Maximum File size in Bytes 
    int fFirstSample;
    unsigned int fSamples;
    int fCCPort;
    int fLastVMESlot;
    int fFirstVMESlot;
    char fHVFeedbackConfig[MAX_PATH];
    double fDefaultFrequency;
    
    // Status variables    
    int NParam;       	      	// Number of command parameters
    const char *Param[MAX_NUM_TOKEN]; // Pointers to parameters
    bool CmdFromSocket;       	// Current command issued via socket
    int NumBoards;
    int FirstBoard;
    int LastBoard;
    float *DRSFreq;   	      	// DRS sampling frequency [GHz]
    BoardStructure *BStruct;
    state_enum   daq_state;
    runtype_enum daq_runtype;
    int Socket;			// -1 if not connected
    pthread_t *SocketThread;	// exit function sends signal to this thread
    bool Exit;
    bool Stop;	      	      	// Set to true to stop run
    unsigned int NumEvents;		// Number of event taken            
    unsigned int NumEventsRequested;	// Number of events requested
    unsigned int RunNumber, FileNumber; 
    char FileName[MAX_PATH];
    char Prompt[MAX_COM_SIZE];
    bool ConfigOK;
       
    // Public functions
    DAQReadout(const char*);
    ~DAQReadout();

    void cmd_exit();	  void cmd_help();
    void cmd_board();	  void cmd_status();
    void cmd_led();	  void cmd_freq();
    void cmd_calib();	  void cmd_serial();
    void cmd_trigger();	  void cmd_delayed();
    void cmd_wmode();	  void cmd_rmode();
    void cmd_mode();	  void cmd_read();
    void cmd_stop();	  void cmd_test();
    void cmd_regtest();	  void cmd_ramtest();
    void cmd_start();	  void cmd_take();
    void cmd_config();	  void cmd_events();
    void cmd_disk();	  void cmd_uptime();
      
    void cmd_fmode(); 	  void cmd_faverage();
    void cmd_ftarget();   void cmd_fgain();
    void cmd_fresponse(); void cmd_fconfig();

    void CommandControl(char*);  
    void StartDRS();
    void StopDRS();
    void StopRun();
    bool IsDRSBusy();
    bool IsDRSFreqSet();
    void SetDRSFrequency(double, bool);
    void SetDOMINOMode(int);
    void SetDOMINOReadMode(int);
    void SetDOMINOWaveMode(int);
    void SetDelayedStart(int);
    void HWTrigger(int); 
    bool ReadCalibration();
    void ReadCalibratedDRSData();
    void PrintConfig(int);
    void PrintMessage(int, const char*, ...);
    void PrintMessage(const char*, ...);
    void DoPrintMessage(const char*, va_list, int); 
    bool OpenRawFile();
    bool WriteRunHeader();
    bool UpdateRunHeader(unsigned int, bool);
    bool WriteEvent();
};

void DAQ(DAQReadout *);
void DAQ_Silent(DAQReadout *);

bool Match(const char*, const char*);
int ParseInput(char*, const char *Param[]);
int CheckDisk(char*);
bool ReadCard(const char *, void *, char, FILE *, unsigned int=1);

#endif
