#include <stdio.h>
//#include "rcc_error/rcc_error.h"
//#include "vme_rcc/vme_rcc.h"
#include "v560.h"
//******************************************************************************
//Constants
//******************************************************************************

#define NMAX_V560_MODULES 10 //maximum 65535, probably more than enough...
#define V560_CHANNELS 16

//******************************************************************************
//Type definitions
//******************************************************************************

//This struct maps the memory of a v560 module.

//This struct contains the information necessary to handle one module


//******************************************************************************
//Global Variables
//******************************************************************************

v560_module_t v560_modules[NMAX_V560_MODULES];

//******************************************************************************
//Function Definitions
//******************************************************************************

VME_ErrorCode_t V560_Open()
{	
  VME_ErrorCode_t error_code;
  //first open connection to VME:
  /*if(error_code = VME_Open()) {
    VME_ErrorPrint(error_code);
    printf("VME open not successful.\n");
    return error_code;
    }*/
    u_int tmp_virtual_address, tmp_base_address;
	u_short i=0;

	VME_MasterMap_t master_map;
	
	master_map.vmebus_address	= 0x00010000;
	master_map.window_size		= 0x1000;
	master_map.address_modifier	= VME_A24;
	master_map.options			= 0;
	
	for(i=0; i<NMAX_V560_MODULES; i++) {
		v560_modules[i].present = 0;
	}
	
	//opening the file containing the base addresses
	FILE *datfile = fopen("v560_base.dat","r");
	char line[256];
	
	i=0;
	if (datfile!=NULL) {
		while(fgets(line,255,datfile)) {
			
			//excluding comment lines
			if(line[0] == '%') {
				continue;
			}
			
			//reading the hex address
			if(!sscanf(&line[2],"%8x",&tmp_base_address)) {
				printf("Reading input file v560_base.dat: non-comment line without address found. Please delete or comment this line.\n");
			}
			
			//check address, assign to the master map
			if(tmp_base_address & 0x0000FFFF) {
				printf("Reading input file v560_base.dat: 0x%08x is no valid base address (0xXXXX0000)\n",tmp_base_address);
				continue;
			}
			if(i>=NMAX_V560_MODULES) {
				printf("Reading input file v560_base.dat: More addresses found than memory space provided.\nIncrease NMAX_V560_MODULES in v560.h and v560.c.\n");
				break;
			}
			master_map.vmebus_address = tmp_base_address;
			
			if(error_code = VME_MasterMap(&master_map,&v560_modules[i].master_mapping)) {
				VME_ErrorPrint(error_code);
				return error_code;
			}

			if(error_code = VME_MasterMapVirtualAddress(v560_modules[i].master_mapping,&tmp_virtual_address)) {
				VME_ErrorPrint(error_code);
				return error_code;
			}
			printf("%i\n",sizeof(v560_registers_t));
			v560_modules[i].registers = (v560_registers_t *) tmp_virtual_address;
			printf("%i\n",sizeof(*(v560_modules[i].registers)));
			u_short zahl= v560_modules[i].registers->manufacturer_type;
			//u_short zahl= v560_modules[i].registers[0xFC];

			//printf
			printf("0x%01X%01X%01X%01X\n", zahl>>12 & 0xF,zahl>>8 & 0xF, zahl>>4 & 0xF,zahl & 0xF);
			zahl= v560_modules[i].registers-> fixed_code;
			
			printf("0x%01X%01X%01X%01X\n", zahl>>12 & 0xF,zahl>>8 & 0xF, zahl>>4 & 0xF,zahl & 0xF);
			zahl= v560_modules[i].registers-> version_series;
			printf("0x%01X%01X%01X%01X\n", zahl>>12 & 0xF,zahl>>8 & 0xF, zahl>>4 & 0xF,zahl & 0xF);

			//printf("%h",v560_modules[i].registers->manufacturer_type);
			//if(v560_modules[i].registers->manufacturer_type==0x0818) {
			if(v560_modules[i].registers->manufacturer_type==0x083A) {
			  //printf("v560-module %i found at address 0x%08x:\n\tMaster mapping: %i\n\tVirtual address: 0x%08x\n\n",i+1,tmp_base_address,v560_modules[i].master_mapping,v560_modules[i].registers);
				v560_modules[i].present = 1;
			}
			else {
				printf("Module %i at address 0x%08x is not of type v560, or module not found. Please check the v560_base.dat-file.\n\n",i+1,tmp_base_address);
				v560_modules[i].present = 0;
				if(error_code = VME_MasterUnmap(v560_modules[i].master_mapping)) {
					VME_ErrorPrint(error_code);
					return error_code;
				}
				}
			
			i++;
		}
		fclose(datfile);
	}
	else { printf("File v560_base.dat containing the base addresses of the v560-modules not found.\n"); error_code = VME_FILE; return error_code; }
	
	return VME_SUCCESS;
}

//******************************************************************************

int V560_Send_Scale_Increment(short module)
{
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  v560_modules[module-1].registers->scale_increase =1;
  return 0;
}

//******************************************************************************

int V560_Set_Veto(short module)
{
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  v560_modules[module-1].registers-> VME_veto_set =1;
  return 0;
}
//******************************************************************************

int V560_Reset_Veto(short module)
{
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  v560_modules[module-1].registers-> VME_veto_reset =1;
  return 0;
}

//******************************************************************************
int V560_Clear_Scales(short module)
{
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  v560_modules[module-1].registers-> scale_clear =1;
  return 0;
}
//******************************************************************************

u_short V560_Read_Request_Register(short module){
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  return v560_modules[module-1].registers-> request_register;
}
//******************************************************************************

int V560_Write_Request_Register(short module,short request){
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  v560_modules[module-1].registers-> request_register = request;
  return 0;
}
//******************************************************************************
int V560_Clear_VME_Interrupt(short module)
{
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
  //read or write access to base + %56 increases all counters by one:
  v560_modules[module-1].registers-> clear_VME_interrupt =1;
  return 0;
}
//******************************************************************************
int V560_Read_Counter(short module, short channel)
{
  if((module>NMAX_V560_MODULES) || (v560_modules[module-1].present != 1)) { return 1; }
   if((channel >V560_CHANNELS ) || (channel<0)) {return 1;}
    
    int counts = v560_modules[module-1].registers->counter[channel];
    return counts;


}


//******************************************************************************

//******************************************************************************



//******************************************************************************



//******************************************************************************

//******************************************************************************

int V560_Print_Info(void)
{
  //return values
  //0: print to stdio successful
  
  u_short manufacturer, type, version, sn, i;
  
  for(i=0; i<NMAX_V560_MODULES; i++) {
    if(v560_modules[i].present != 1) {
      //printf("Module %i is not present.\n",i+1);
      continue;
    }
    
    printf("v560-module %i (master mapping %i) found:\n",i+1,v560_modules[i].master_mapping);
    manufacturer = v560_modules[i].registers->manufacturer_type;		manufacturer &= 0xFC00; // 0b1111 1100 0000 0000
    type = v560_modules[i].registers->manufacturer_type;				type &= 0x03FF;			// 0b0000 0011 1111 1111
    version = v560_modules[i].registers-> version_series;		version &= 0xF000;			// 0b1111 0000 0000 0000
    sn = v560_modules[i].registers-> version_series;			sn &= 0x0FFF;				// 0b0000 1111 1111 1111
    printf("Manufacturer: 0x%04x\nType: 0x%04x\nVersion: 0x%04x\nSerial Number:0x%04x\n\n", manufacturer, type, version, sn);
  }
  return 0;
}

//******************************************************************************

VME_ErrorCode_t V560_Close(void)
{
	VME_ErrorCode_t error_code;
	u_short i;
	
	for(i=0; i<NMAX_V560_MODULES; i++) {
		if(v560_modules[i].present != 1) continue;
		
		printf("Closing v560-module %i with master mapping %i...",i+1,v560_modules[i].master_mapping);
		if(error_code = VME_MasterUnmap(v560_modules[i].master_mapping)) {
			VME_ErrorPrint(error_code);
			return error_code;
		}
		printf("closed.\n");
	}
	//and close the VME:
	/*if(error_code = VME_Close()) {
	  VME_ErrorPrint(error_code);
	  printf("VME close not succesful.\n");
	  return error_code;
	  }*/

	return VME_SUCCESS;
}

//******************************************************************************
