----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Patrick Vogler
-- 
-- Create Date:    March 2 2010
-- Design Name:    
-- Module Name:    FTM Lightpulser interface: single lightpulser
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    generates the signals to control a single lightpulser
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
--
-- modifications:
--
--
--        
-- modified:     May 26 2011
--               by Patrick Vogler
--               "Lightpulser Basic Version"
--
-- modified:     May 27 2011
--               by Patrick Vogler
--
-- modified:     May 27 2011
--               by Patrick Vogler, Quirin Weitzel
--               -> clean up
--
--
-- modified:     July 20 2011
--               by Patrick Vogler
--               reduce minimal LED light output and increase dynamic range
--
----------------------------------------------------------------------------------
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;



entity single_LP_Basic is
  port(
    
-- Clock
-------------------------------------------------------------------------------
   clk_50    : IN  STD_LOGIC;          --  50 MHz system clock 
--   clk_250   : IN  STD_LOGIC;        -- 250 MHz system clock
   
-- Lightpulser
-------------------------------------------------------------------------------
   LP_Pulse_out    : out STD_LOGIC :='0';     --  

   
-- FPGA intern signals: Lightpulser brightness
-------------------------------------------------------------------------------                                            
   LP_pulse_in          : in std_logic               -- trigger lightpulse

--   LP_delay             : in std_logic_vector (15 downto 0)   
  );
end single_LP_Basic;

architecture Behavioral of single_LP_Basic is

signal LP_in_prev : STD_LOGIC := '0';
signal Pulse_Flag : STD_LOGIC := '0';

begin

single_LP_Basic_proc: process (clk_50)

variable Y   : integer range 0 to FLD_PULSE_LENGTH_Pulse;

begin  
 	 
    if rising_edge(clk_50) then       
       LP_in_prev <= LP_pulse_in;
      
       if ((LP_pulse_in = '1') and (LP_in_prev = '0')) then
         Pulse_Flag <= '1';
       end if;        
      
       if (Pulse_Flag = '1') then
         if (Y < FLD_PULSE_LENGTH_Pulse) then 
           Y := Y + 1;
           LP_Pulse_out <= '1';
         else
           Y := 0;
           LP_Pulse_out <= '0';
           Pulse_Flag   <= '0';
         end if; 
       end if;  

    end if;
 
end process single_LP_Basic_proc;
  
end Behavioral;
