#include "parser.h"
#include "output.h"
#include "application.h"
#include "usart.h"
#include "w5100_spi_interface.h"
#include "timer.h"
// this method parses the data, 
// which came in via USART
// later it might as well parse the data from ethernet.
void parse_ascii() {
	usart_rx_buffer[USART_RX_BUFFER_SIZE-1] = 0;
	usart_write_str((pU08)"got:");
	usart_write_str(usart_rx_buffer);
	
// look at first byte
// I hope, I can manage to use one byte commands
	switch (usart_rx_buffer[0]) {
		case 'E': 	// AD7719 enable bitmaps may be set
			set_ad7719_enable_register();
			break;
		case 'e':	// ATmega internal ADC enable bitmaps may be set
			// not supported yet.
			set_adc_enable_register();
			break;
		case 'h':
			usart_write_str((pU08)"\nheartbeat ");
			heartbeat_enable = true;
			if (usart_rx_buffer[1] == '0'){
				heartbeat_enable = false;
				usart_write_str((pU08)"off\n");
			} else {
				usart_write_str((pU08)"on\n");
			}
			break;
		case 'G': 			// GET the Temperature channels, which are enabled
			once_told_you = false;
			for ( U08 i=0; i<RESISTANCE_CHANNELS/8; ++i ) {
				ad7719_channels_ready[i]=0;
			}
			break;

		case 'g':			// GET the voltage/current/humidity channels, which are enabled
			once_told_you = false;
			for ( U08 i=0; i<VOLTAGE_REGS; ++i ) {
				adc_channels_ready[i]=0;
			}
			break;

		case 'P':
			print_ad7719_nicely();
			break;
			
		case 'p':
			print_adc_nicely();
			break;

		case 's':
			print_status();
			break;	

		case 'd':
			usart_write_str((pU08)"\ndebug mode ");
			debug_mode = true;
			if (usart_rx_buffer[1] == '0'){
				debug_mode = false;
				usart_write_str((pU08)"off\n");
			} else {
				usart_write_str((pU08)"on\n");
			}
			break;		
	}
	
	
	usart_write_str((pU08)"\nready?");
	for (U08 i=0; i<USART_RX_BUFFER_SIZE; ++i)
		usart_rx_buffer[i] = 0;
}

void parse_non_human_readable_input() {


}

// this guy checks, if an incoming byte is:
// to be stored, because it belongs to a command
// to be discarded, because something went wrong, and the bytemade no sense...
// the end of a commmand, and so the 'real parser' may do his work.
/*
void incoming_byte_parser() {
	static bool receiving_command = false;
	U08 current_byte = UDR;
	
	if (!receiving_command) { 
		switch (current_byte) {
			case 0x01:
				receiving_command = true;
				break;
		}
	}
	
	if (receiving_command)
	{
		usart_rx_buffer[usart_received_chars] = usart_last_char;
		usart_received_chars++;
	}
	
	
}
*/


// this is the recent MSR parser
/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////// P A R S E R /////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
// this method parses the data, 
// which came in via USART
// later it might as well parse the data from ethernet.
void MSR_parser() {

U08 input_number = 0;
bool enable = false;
// look at first byte
// I hope, I can manage to use one byte commands
	usart_rx_buffer[USART_RX_BUFFER_SIZE-1] = 0;
	usart_write_char(' ');
	usart_write_str(usart_rx_buffer);
	usart_write_char('\n');
	

	if (usart_received_chars >0) {
		switch (usart_rx_buffer[0]) {
			case 'E': 		// user wants to enable/disable something
			case 'e':
				enable = true;
			case 'D':
			case 'd':
			
				if (usart_received_chars>=1) {  // let's see what.
					if ( 	usart_rx_buffer[1] != 'r'  &&
							usart_rx_buffer[1] != 'v'  &&
							usart_rx_buffer[1] != 'h'  &&
							usart_rx_buffer[1] != 'p' )
						{
							//print_invalid_enable_statement();
							break;
						}
				}
				
				input_number = 0;
				if (usart_received_chars >2) {  // lets check the first digit
					if ( usart_rx_buffer[2] >= '0' && usart_rx_buffer[2] <= '9' ) {
						input_number = usart_rx_buffer[2] - '0';
					} else {
						//print_invalid_enable_statement();
						break;
					}
				}
				if (usart_received_chars >3) {  // lets check the 2nd digit
					if ( usart_rx_buffer[3] >= '0' && usart_rx_buffer[3] <= '9' ) {
						input_number = 10*input_number + usart_rx_buffer[3] - '0';
					} else {
						// okay as well ... if the second digit is missing .. 
						// we might have trailing spaces
						// that's okay .. we just accept the first number.
					}
				}
				if (usart_received_chars>2) {
					usart_write_str((pU08)"\n I will switch ");
					if (enable) 
						usart_write_str((pU08)"on ");
					else
						usart_write_str((pU08)"off ");
					
					// now we know, what the user wanted ... and we need to do it.
					switch (usart_rx_buffer[1]) {
						case 'r':
							if (enable)
								ad7719_enables[input_number/8] |= (1<<(input_number%8));
							else {
								ad7719_enables[input_number/8] &= ~(1<<(input_number%8));
								ad7719_channels_ready[input_number/8] &= ~(1<<(input_number%8));
								}
							usart_write_str((pU08)" resistance channel ");
							usart_write_U08(input_number,2);
							usart_write_char('\n');
							break;
						case 'v':
							if (enable)
								adc_enables[input_number/8] |= (1<<(input_number%8));
							else {
								adc_enables[input_number/8] &= ~(1<<(input_number%8));
								adc_channels_ready[input_number/8] &= ~(1<<(input_number%8));
								}
							usart_write_str((pU08)" voltage channel ");
							usart_write_U08(input_number,2);
							usart_write_char('\n');
							break;
							
						case 'h':
							if (enable)
								adc_enables[1] |= (1<<(input_number%4));
							else {
								adc_enables[1] &= ~(1<<(input_number%4));
								adc_channels_ready[1] &= ~(1<<(input_number%4));
								}
							usart_write_str((pU08)" humidity channel ");
							usart_write_U08(input_number,2);
							usart_write_char('\n');
							break;
						case 'p':
							if (enable)
								adc_enables[1] |= (1<<((input_number%4) + 4));
							else {
								adc_enables[1] &= ~(1<<((input_number%4) + 4));
								adc_channels_ready[1] &= ~(1<<((input_number%4) + 4));
								}
							usart_write_str((pU08)" pressure channel ");
							usart_write_U08(input_number,2);
							usart_write_char('\n');
							break;
						default:
							usart_write_str((pU08)"\n DAMN! this should never happen"
							"- enable/disable switch-case!\n");
							break;
					}
					
					
					
				}// end of if usart_received_chars>2  --> this should not be necessary at all
				break;
				
			case 'b':
				usart_write_str((pU08)"\nheartbeat ");
				heartbeat_enable = true;
				if (usart_rx_buffer[1] == '0'){
					heartbeat_enable = false;
					usart_write_str((pU08)"off\n");
				} else {
					usart_write_str((pU08)"on\n");
				}
				break;
			case 'G': 			// GET the Temperature channels, which are enabled
				ad7719_values_printed = false;
				reset_resistance_done();
				reset_resistance_values();				
				break;
				
			case 'g':			// GET the voltage/current/humidity channels, which are enabled
				adc_values_printed = false;
				reset_voltage_done();
				reset_voltage_values();
				break;

			case 'p':
					adc_print_endless = true;
				if (usart_rx_buffer[1] == '0')
					adc_print_endless = false;
				break;		

			case 'P':
					ad7719_print_endless = true;
				if (usart_rx_buffer[1] == '0')
					ad7719_print_endless = false;
				break;		
			
			case 's':
				print_status();
				//print_adc_enable_status(true);
				//usart_write_char('\n');

				//print_ad7719_enable_status(true);
				//usart_write_char('\n');
			
				//usart_write_str((pU08)"time:");
				//usart_write_float((float)local_ms/1000 , 1,7);
				//usart_write_str((pU08)" sec.\n");
				break;	
				
			case 'S':
				write_status_via_eth();
				break;

			case '!':
				usart_write_str((pU08)"\ndebug mode ");
				debug_mode = true;
				if (usart_rx_buffer[1] == '0'){
					debug_mode = false;
					usart_write_str((pU08)"off\n");
				} else {
					usart_write_str((pU08)"on\n");
				}
				break;		
				
			case 'h':
			case 'H':
				print_help();
				break;
		}
	} else
	{
		// zero bytes received
	}
	
	
	for (U08 i=0; i<USART_RX_BUFFER_SIZE; ++i)
		usart_rx_buffer[i] = 0;
	usart_received_chars = 0;	
	usart_rx_ready = false;
}	// END of MSR_parser();



///////////////////////////////////////////////////////////////////////////////////////
// W5300 incoming commands parser
void parse_w5300_incoming( U08 bytes_in_w5100_rx_buffer ) {

	usart_writeln_str((pU08)"parsget:");
	for (U08 i =0; i< ETH_READ_BUFFER_SIZE ; i++) {
		usart_write_U08_hex(eth_read_buffer[i]);
		usart_write_char((U08)eth_read_buffer[i]);
		
	}
	usart_write_crlf();

	if (bytes_in_w5100_rx_buffer == 0) // it was stupid to call this parser without having any bytes downloaded
		return;
		
	switch (eth_read_buffer[0]) {
		case 'w': // *w*rite to register command
			write_FSC_register();
			read_FSC_register(); 
			break;
			
		case 'r':	// *r*ead from register command
			read_FSC_register();
			break;
			
		case 't':	// measure *t*emperature (resistance) channels only
			ad7719_values_printed = false;
			reset_resistance_done();
			simple_acknowledge();
			break;
			
		case 'v':	// measure *v*oltage channels only
			adc_values_printed = false;
			reset_voltage_done();
			simple_acknowledge();
			break;
			
		case 'm':	// *m*easure active channels commands
			reset_done();
			ad7719_print_endless = true;
			
			simple_acknowledge();
			break;
			
		case 's':	// return *s*tatus information
			// this might take a lot of time... about... 25us per byte .. --> less than 25ms
			write_status_via_eth();
			//w5100_set_TX(FSCregister, FSC_REGISTER_LENGTH);
			break;
			
		case 'k':
			eth_write_stuff();
			break;
		
		case 'z':	// re*z*et ATmega32 and peripherals
			eth_write_buffer[0]='!';
			eth_write_buffer[1]='!';
			w5100_set_TX(eth_write_buffer, 2); 
			// let watchdog occur!
			// gotta read, how this works...
			break;	
	}
}

void write_FSC_register() {
	FSCregister[eth_read_buffer[2]]=eth_read_buffer[3];
}

void read_FSC_register() {
	eth_write_buffer[0]=eth_read_buffer[0];
	eth_write_buffer[1]=eth_read_buffer[1];
	eth_write_buffer[2]=eth_read_buffer[2];
	eth_write_buffer[3]=FSCregister[eth_read_buffer[2]];
	w5100_set_TX(eth_write_buffer, 4); 
}

void reset_resistance_done(){
	for (U08 i=0; i < (RESISTANCE_CHANNELS/8); i++){
		ad7719_channels_ready[i] = 0;
	}
}
void reset_resistance_values(){
	for (U08 i=0; i < RESISTANCE_CHANNELS; i++){
		ad7719_values[i] = 0;
	}
}


void reset_voltage_done(){
	for (U08 i=0; i < (VOLTAGE_REGS); i++){
		adc_channels_ready[i] = 0;
	}
}
void reset_voltage_values(){
	for (U08 i=0; i < VOLTAGE_CHANNELS; i++){
		adc_values[i] = 0;
	}
}

void reset_done(){
	reset_resistance_done();
	reset_voltage_done();
}

void simple_acknowledge(){
	eth_write_buffer[0]=eth_read_buffer[0];
	eth_write_buffer[1]=eth_read_buffer[1];
	w5100_set_TX(eth_write_buffer, 2); 
}

void write_status_via_eth() {
float resistance;

	// take care: ethernet write buffer is just 32 bytes long.
	eth_write_str("status: "); 				eth_writeln_str(nc_U32_to_hex(status));
	// better switch off interrupts here:
	// otherwise the numbers in time_sec and time_ms might get corrupt during output.
	cli();
	eth_write_str("time_s: "); 				eth_write_str(nc_U32_to_str(sec, 1));
	eth_write_str(".");eth_writeln_str(nc_U16_to_str(milisec, 1));
	//eth_write_str("mili_s: "); 				eth_writeln_str(nc_U16_to_str(milisec, 1));
	sei();
	
	//eth_write_str("R_ref : "); 				eth_writeln_str(nc_U16_to_str(ref_resistor, 6));
	
	eth_writeln_str("VOLTAGES\n");
		eth_write_str("enable:"); 				
		for (U08 i=0; i<VOLTAGE_REGS ; i++){
			eth_write_str(nc_U08_to_bin(adc_enables[i]));
			// need to tweak here in order to get some nice spaces...
			eth_write_buffer[eth_write_index] = ' ';
			eth_write_index++;
		}
		eth_write_buffer[eth_write_index++] = '\n';
		
		eth_write_str("  done:"); 				
		for (U08 i=0; i<VOLTAGE_REGS ; i++){
			eth_write_str(nc_U08_to_bin(adc_channels_ready[i]));
			// need to tweak here in order to get some nice spaces...
			eth_write_buffer[eth_write_index] = ' ';
			eth_write_index++;
		}
		eth_write_buffer[eth_write_index++] = '\n';
		
		eth_write_str("values:"); 				
		for (U08 i=0; i<VOLTAGE_CHANNELS ; i++){
			eth_write_str(nc_U16_to_str(adc_values[i]/10, 1) );
			// need to tweak here in order to get some nice spaces...
			eth_write_buffer[eth_write_index] = ' ';
			eth_write_index++;
		}
		eth_write_buffer[eth_write_index++] = '\n';
		
	eth_writeln_str("RESISTANCES\n");
		eth_write_str("enable:"); 				
		for (U08 i=0; i<(RESISTANCE_CHANNELS/8) ; i++){
			eth_write_str(nc_U08_to_bin(ad7719_enables[i]));
			// need to tweak here in order to get some nice spaces...
			eth_write_buffer[eth_write_index] = ' ';
			eth_write_index++;
		}
		eth_write_buffer[eth_write_index++] = '\n';
		
		eth_write_str("  done:"); 				
		for (U08 i=0; i<(RESISTANCE_CHANNELS/8) ; i++){
			eth_write_str(nc_U08_to_bin(ad7719_channels_ready[i]));
			// need to tweak here in order to get some nice spaces...
			eth_write_buffer[eth_write_index] = ' ';
			eth_write_index++;
		}
		eth_write_buffer[eth_write_index++] = '\n';

		eth_write_str("values:\n"); 				
		for (U08 i=0; i<RESISTANCE_CHANNELS ; i++){
			//eth_write_str(nc_U32_to_str(ad7719_values[i], 10) );
			
			resistance = (6.25 * 1024 * ad7719_values[i]) / ((U32)1 << 25);
			eth_write_str(nc_float_to_str(resistance , 2, 2) );
			// need to tweak here in order to get some nice spaces...
			if (i%8 == 7)
				eth_write_buffer[eth_write_index] = '\n';
			else
				eth_write_buffer[eth_write_index] = ' ';
			
			eth_write_index++;
		}
		eth_writeln_str("\nend.\n");
		

}

void eth_write_stuff(void) {
	S08 buf []="Test Ah A!!\n";
	for (U08 i =0 ; i<255 ; i++) {
		eth_write_str(nc_U08_to_str(i,4));
		eth_write_str(buf);
	}
}
