/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MMcRunHeader
//
// Root storage container for the RUN MONTE CARLO HEADER information
//
////////////////////////////////////////////////////////////////////////////

#include "MMcRunHeader.hxx"

#include <fstream.h>
#include <iomanip.h>

#include "MLog.h"

ClassImp(MMcRunHeader);

// --------------------------------------------------------------------------
//
// Default constructor. Creates array which stores the pixel assignment.
//
//
MMcRunHeader::MMcRunHeader(const char *name, const char *title)
{
    fName  = name  ? name  : "MMcRunHeader";
    fTitle = title ? title : "Raw Run Header Information";

    fNumTrigCond = 0;
    fAllEvtsTriggered = 0 ;
    fMcEvt = 0;
    fMcTrig = 0;
    fMcFadc = 0;
    fNumAnalisedPixels = 0;
    fNumSimulatedShowers = 0;
    fNumStoredShowers = 0;

    fStarFieldRaH = 0;
    fStarFieldRaM = 0;
    fStarFieldRaS = 0;
    fStarFieldDeD = 0;
    fStarFieldDeM = 0;
    fStarFieldDeS = 0;

    fNumPheFromDNSB = 0.0;
    fTelesTheta = 0.0;
    fTelesPhi = 0.0;
    fSourceOffsetTheta = 0.0; 
    fSourceOffsetPhi = 0.0;
    fShowerThetaMax = 0.0;
    fShowerThetaMin = 0.0;
    fShowerPhiMax = 0.0;
    fShowerPhiMin = 0.0;

    fCorsikaVersion = 0;
    fReflVersion = 0;
    fCamVersion = 0;

}

// --------------------------------------------------------------------------
//
// Destructor.
//
MMcRunHeader::~MMcRunHeader()
{

}

// -------------------------------------------------------------------------
//
// Fill. Put data in the container
//
void MMcRunHeader::Fill(const UInt_t numtrigcond,
			const Byte_t fallevts,
			const Byte_t fmcevt,
			const Byte_t fmctrig,
			const Byte_t fmcfadc,
			const Int_t  fnumanalpixels,
			const UInt_t fnumsim,
			const UInt_t fnumsto,
			const Int_t fsfRaH,
			const Int_t fsfRaM,
			const Int_t fsfRaS,
			const Int_t fsfDeD,
			const Int_t fsfDeM,
			const Int_t fsfDeS,
			const Float_t fnumdnsb,
			const Float_t ftelestheta,
			const Float_t ftelesphi,
			const Float_t fsofftheta,
			const Float_t fsoffphi,
			const Float_t fshthetamax,
			const Float_t fshthetamin,
			const Float_t fshphimax,
			const Float_t fshphimin,
			const UInt_t fcorsika,
			const UInt_t frefl,
			const UInt_t fcam
    ){
    fNumTrigCond = numtrigcond;
    fAllEvtsTriggered = fallevts;
    fMcEvt = fmcevt;
    fMcTrig = fmctrig;
    fMcFadc = fmcfadc;
    fNumAnalisedPixels = fnumanalpixels;
    fNumSimulatedShowers = fnumsim;
    fNumStoredShowers = fnumsto;

    fStarFieldRaH = fsfRaH;
    fStarFieldRaM = fsfRaM;
    fStarFieldRaS = fsfRaS;
    fStarFieldDeD = fsfDeD;
    fStarFieldDeM = fsfDeM;
    fStarFieldDeS = fsfDeS;

    fNumPheFromDNSB = fnumdnsb;
    fTelesTheta = ftelestheta;
    fTelesPhi = ftelesphi;
    fSourceOffsetTheta = fsofftheta; 
    fSourceOffsetPhi = fsoffphi;
    fShowerThetaMax = fshthetamax;
    fShowerThetaMin = fshthetamin;
    fShowerPhiMax = fshphimax;
    fShowerPhiMin = fshphimin;

    fCorsikaVersion = fcorsika;
    fReflVersion = frefl;
    fCamVersion = fcam;
}

// -------------------------------------------------------------------------
//
// GetStarFieldRa. Get RA coordinates of the starfield
//
void MMcRunHeader::GetStarFieldRa(Int_t *hour, Int_t *minute, Int_t *second)
{
    *hour=fStarFieldRaH;
    *minute=fStarFieldRaM;
    *second=fStarFieldRaS;
}
// -------------------------------------------------------------------------
//
// GetStarFieldDec. Get DE coordinates of the starfield
//
void MMcRunHeader::GetStarFieldDec(Int_t *degree, Int_t *minute, Int_t *second)
{
    *degree=fStarFieldDeD;
    *minute=fStarFieldDeM;
    *second=fStarFieldDeS;
}
