#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
 int main(int argc, char *argv[])
{
	
	FILE *plotfile;

	char tempFilename[80];
	long startTime;
	char usingStr[40];
	
	time_t rawtime;
	struct tm * timeinfo;
	
	if (argc < 3) {
		fprintf (stderr, "usage: plot <filename.slow> Starttimemodifier e.g. 3600 \n");
		return -1;
		}
	if (argc > 3) {
		fprintf (stderr, "too many arguments: usage: plot <filename.slow> Starttimemodifier e.g. 300\n");
		return -1;
		}

	time ( &rawtime );

	startTime = (long)rawtime;
	strcpy(tempFilename, argv[1]);
	
	startTime -= atoi(argv[2]);
	rawtime -= atoi(argv[2]);

	plotfile = fopen ("plot_t.plt","w");
  
        timeinfo = localtime ( &rawtime );
	fprintf (plotfile, "set title 'Temps since %s\n", asctime (timeinfo) );	
	
	if (plotfile!=NULL)
  	{
		fputs (	"set xlabel 'time sec '\n"
			"set ylabel 'T in C '\n"
			"set grid\n"
		,plotfile);

	sprintf(usingStr, "($10>\%d ? $10-\%d : 1/0)", startTime, startTime);
	
	fputs("plot ",plotfile);
	
	fprintf(plotfile, "\"%s\" using %s:11 title 'water out' with points"
				,tempFilename
				,usingStr
				);	
	
	fputs(", \\\n", plotfile);
	fprintf(plotfile, "\"%s\" using %s:12 title 'upper right' with points" 
				,tempFilename
				,usingStr
				);	
	fputs(", \\\n", plotfile);
	fprintf(plotfile, "\"%s\" using %s:13 title 'upper left' with points" 
				,tempFilename
				,usingStr
				);	
	fputs(", \\\n", plotfile);
	fprintf(plotfile, "\"%s\" using %s:14 title 'lower left' with points" 
				,tempFilename
				,usingStr
				);	
	fputs(", \\\n", plotfile);
	fprintf(plotfile, "\"%s\" using %s:15 title 'lower right' with points" 
				,tempFilename
				,usingStr
				);	
	fputs(", \\\n", plotfile);
	fprintf(plotfile, "\"%s\" using %s:16 title 'water in' with points" 
				,tempFilename
				,usingStr
				);	
	fputs(", \\\n", plotfile);
	fprintf(plotfile, "\"%s\" using %s:17 title 'humidity temp' with points" 
				,tempFilename
				,usingStr
				);	
	fputs("\n", plotfile);

	fputs("pause -1 \"Hit any key or press OK to continue ...\"\n",plotfile);

	fclose (plotfile);
	}
	
	system("gnuplot plot_t.plt");

	system("rm plot_t.plt");
	return 0;	
}
