#ifndef FACT_DataWriteFits
#define FACT_DataWriteFits

#include "DataProcessorImp.h"
#include "FitsFile.h"

class Converter;

class DataWriteFits : public DataProcessorImp
{
    FitsFile fFile;

    Converter *fConv;

    template <typename T>
        void WriteKey(const string &name, const int idx, const T &value, const string &comment);

    bool WriteFooter(RUN_TAIL *rt);

public:
    DataWriteFits(uint32_t runid, MessageImp &imp) :
        DataProcessorImp(runid, imp), fFile(imp)
    {
    }

    ~DataWriteFits();

    bool Open(RUN_HEAD* h);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL *rt = 0);
};
#endif
