#ifndef FACT_DataCalib
#define FACT_DataCalib

#include "DataProcessorImp.h"

using namespace std;
#include "DrsCalib.h"

class DimDescribedService;

class DataCalib : public DataProcessorImp, CalibData
{
    static std::vector<int32_t> fOffset;
    static std::vector<int32_t> fGain;
    static std::vector<int32_t> fTrgOff;

    static std::vector<float>   fStats;

    static uint64_t fNumOffset;
    static uint64_t fNumGain;
    static uint64_t fNumTrgOff;

    static int fStep;

    DimDescribedService &fDim;

    void WriteFits();

public:
    DataCalib(uint32_t id, DimDescribedService &dim, MessageImp &imp) : DataProcessorImp(id, imp), fDim(dim)
    {
    }

    static void Restart();
    static void Update(DimDescribedService &dim);

    bool Open(RUN_HEAD* h);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL * = 0);

    static void Apply(int16_t *val, const int16_t *start, uint32_t roi);
    static void Apply(float *vec, int16_t *val, const int16_t *start, uint32_t roi);
};

#endif
