--
-- VHDL Architecture FACT_FAD_TB_lib.REFCLK_counter_tester.beha
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 08:52:02 04.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.ALL;

ENTITY REFCLK_counter_tester IS
   PORT( 
      alarm_refclk_too_high : IN     std_logic;
      alarm_refclk_too_low  : IN     std_logic;
      counter_result        : IN     std_logic_vector (11 DOWNTO 0);
      clk                   : out   std_logic;
      refclk_in             : OUT    std_logic
   );

-- Declarations

END REFCLK_counter_tester ;

--
ARCHITECTURE beha OF REFCLK_counter_tester IS
constant REFCLK_PERIOD : time := 1012ns;
constant clock_period : time := 20ns;

signal refclk_i : std_logic := '0';
signal refclk_en : std_logic;
  
BEGIN
  refclk_in <= refclk_i and refclk_en;
  
  clk_en_proc: process
  begin
    refclk_en <= '1';
    wait for 4500 us;
    refclk_en <= '0';
    wait;
  end process clk_en_proc;
  
    clock_gen_proc: process
  begin
    clk <= '0';
    wait for clock_period / 2;
    clk <= '1';
    wait for clock_period / 2;
  end process clock_gen_proc;
  
  
  ref_clock_gen_proc: process
    begin
      refclk_i <= '0';
      wait for REFCLK_PERIOD / 2;
      refclk_i <= '1';
      wait for REFCLK_PERIOD / 2;
    end process ref_clock_gen_proc;
  
END ARCHITECTURE beha;

