-- VHDL Entity FACT_FAD_TB_lib.adc_emulator_tb.symbol
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 14:21:48 24.06.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY adc_emulator_tb IS
-- Declarations

END adc_emulator_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.adc_emulator_tb.struct
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 14:21:48 24.06.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_textio.all;
LIBRARY std;
USE std.textio.all;

LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF adc_emulator_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL clk  : std_logic := '0';
   SIGNAL data : std_logic_vector(11 DOWNTO 0);
   SIGNAL oeb  : std_logic;
   SIGNAL otr  : std_logic;


   -- Component Declarations
   COMPONENT adc_emulator
   GENERIC (
      INPUT_FILE : string := "filename"
   );
   PORT (
      clk  : IN     STD_LOGIC ;
      data : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      otr  : OUT    STD_LOGIC ;
      oeb  : IN     STD_LOGIC 
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 20 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : adc_emulator USE ENTITY FACT_FAD_TB_lib.adc_emulator;
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb_adcTB_oeb
   -- eb_adcTB_oeb 1: enable ADC
   enable_proc: process
   begin
     oeb <= '1';
     wait for 1 us;
     oeb <= '0';
     wait;
   end process enable_proc;


   -- Instance port mappings.
   I_adcTB_adc : adc_emulator
      GENERIC MAP (
         INPUT_FILE => "../memory_files/analog_input_ch0.txt"
      )
      PORT MAP (
         clk  => clk,
         data => data,
         otr  => otr,
         oeb  => oeb
      );
   I_adcTB_clock : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => clk,
         rst => OPEN
      );

END struct;
