-- VHDL Entity FACT_FAD_TB_lib.fad_main_tb.symbol
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 16:23:49 09.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY fad_main_tb IS
-- Declarations

END fad_main_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.fad_main_tb.struct
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 16:23:49 09.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;
USE ieee.std_logic_textio.all;
LIBRARY std;
USE std.textio.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF fad_main_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL ADC_CLK               : std_logic;
   SIGNAL CLK_25_PS             : std_logic;
   SIGNAL CLK_50                : std_logic;
   -- for debugging
   SIGNAL DG_state              : std_logic_vector(7 DOWNTO 0);
   SIGNAL D_T_in                : std_logic_vector(1 DOWNTO 0);
   SIGNAL FTM_RS485_rx_d        : std_logic;
   SIGNAL FTM_RS485_rx_en       : std_logic;
   SIGNAL FTM_RS485_tx_d        : std_logic;
   SIGNAL FTM_RS485_tx_en       : std_logic;
   SIGNAL REF_CLK               : STD_LOGIC                    := '0';
   SIGNAL RSRLOAD               : std_logic                    := '0';
   SIGNAL SRCLK                 : std_logic                    := '0';
   SIGNAL SRIN_out              : std_logic                    := '0';
   SIGNAL SROUT_in_0            : std_logic;
   SIGNAL SROUT_in_1            : std_logic;
   SIGNAL SROUT_in_2            : std_logic;
   SIGNAL SROUT_in_3            : std_logic;
   SIGNAL adc_data              : std_logic_vector(11 DOWNTO 0);
   SIGNAL adc_data_array        : adc_data_array_type;
   SIGNAL adc_oeb               : std_logic;
   SIGNAL adc_otr               : STD_LOGIC;
   SIGNAL adc_otr_array         : std_logic_vector(3 DOWNTO 0);
   SIGNAL alarm_refclk_too_high : std_logic;
   SIGNAL alarm_refclk_too_low  : std_logic;
   SIGNAL amber                 : std_logic;
   SIGNAL board_id              : std_logic_vector(3 DOWNTO 0);
   SIGNAL clk                   : STD_LOGIC;
   SIGNAL counter_result        : std_logic_vector(11 DOWNTO 0);
   SIGNAL crate_id              : std_logic_vector(1 DOWNTO 0);
   SIGNAL dac_cs                : std_logic;
   SIGNAL debug_data_ram_empty  : std_logic;
   SIGNAL debug_data_valid      : std_logic;
   SIGNAL denable               : std_logic                    := '0';                -- default domino wave off
   SIGNAL drs_channel_id        : std_logic_vector(3 DOWNTO 0) := (others => '0');
   SIGNAL drs_dwrite            : std_logic                    := '1';
   SIGNAL green                 : std_logic;
   SIGNAL led                   : std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');
   SIGNAL mem_manager_state     : std_logic_vector(3 DOWNTO 0);                       -- state is encoded here ... useful for debugging.
   SIGNAL mosi                  : std_logic                    := '0';
   SIGNAL plllock_in            : std_logic_vector(3 DOWNTO 0);                       -- high level, if dominowave is running and DRS PLL locked
   SIGNAL red                   : std_logic;
   SIGNAL sclk                  : std_logic;
   SIGNAL sensor_cs             : std_logic_vector(3 DOWNTO 0);
   SIGNAL sio                   : std_logic;
   SIGNAL socket_tx_free_out    : std_logic_vector(16 DOWNTO 0);                      -- 17bit value .. that's true
   SIGNAL trigger               : std_logic;
   SIGNAL trigger_veto          : std_logic                    := '1';
   SIGNAL w5300_state           : std_logic_vector(7 DOWNTO 0);                       -- state is encoded here ... useful for debugging.
   SIGNAL wiz_addr              : std_logic_vector(9 DOWNTO 0);
   SIGNAL wiz_cs                : std_logic                    := '1';
   SIGNAL wiz_data              : std_logic_vector(15 DOWNTO 0);
   SIGNAL wiz_int               : std_logic;
   SIGNAL wiz_rd                : std_logic                    := '1';
   SIGNAL wiz_reset             : std_logic                    := '1';
   SIGNAL wiz_wr                : std_logic                    := '1';


   -- Component Declarations
   COMPONENT FAD_main
   GENERIC (
      RAMADDRWIDTH64b : integer := 12
   );
   PORT (
      CLK                   : IN     std_logic ;
      D_T_in                : IN     std_logic_vector (1 DOWNTO 0);
      FTM_RS485_rx_d        : IN     std_logic ;
      SROUT_in_0            : IN     std_logic ;
      SROUT_in_1            : IN     std_logic ;
      SROUT_in_2            : IN     std_logic ;
      SROUT_in_3            : IN     std_logic ;
      adc_data_array        : IN     adc_data_array_type ;
      adc_otr_array         : IN     std_logic_vector (3 DOWNTO 0);
      board_id              : IN     std_logic_vector (3 DOWNTO 0);
      crate_id              : IN     std_logic_vector (1 DOWNTO 0);
      drs_refclk_in         : IN     std_logic ;                                     -- used TO check if DRS REFCLK exsists, if not DENABLE inhibit
      plllock_in            : IN     std_logic_vector (3 DOWNTO 0);                  -- high level, if dominowave is running and DRS PLL locked
      trigger               : IN     std_logic ;
      wiz_int               : IN     std_logic ;
      ADC_CLK               : OUT    std_logic ;
      CLK_25_PS             : OUT    std_logic ;
      CLK_50                : OUT    std_logic ;
      -- for debugging
      DG_state              : OUT    std_logic_vector (7 DOWNTO 0);
      FTM_RS485_rx_en       : OUT    std_logic ;
      FTM_RS485_tx_d        : OUT    std_logic ;
      FTM_RS485_tx_en       : OUT    std_logic ;
      RSRLOAD               : OUT    std_logic                     := '0';
      SRCLK                 : OUT    std_logic                     := '0';
      SRIN_out              : OUT    std_logic                     := '0';
      adc_oeb               : OUT    std_logic                     := '1';
      alarm_refclk_too_high : OUT    std_logic ;
      alarm_refclk_too_low  : OUT    std_logic ;
      amber                 : OUT    std_logic ;
      counter_result        : OUT    std_logic_vector (11 DOWNTO 0);
      dac_cs                : OUT    std_logic ;
      debug_data_ram_empty  : OUT    std_logic ;
      debug_data_valid      : OUT    std_logic ;
      denable               : OUT    std_logic                     := '0';           -- default domino wave off
      drs_channel_id        : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite            : OUT    std_logic                     := '1';
      green                 : OUT    std_logic ;
      led                   : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mem_manager_state     : OUT    std_logic_vector (3 DOWNTO 0);                  -- state is encoded here ... useful for debugging.
      mosi                  : OUT    std_logic                     := '0';
      red                   : OUT    std_logic ;
      sclk                  : OUT    std_logic ;
      sensor_cs             : OUT    std_logic_vector (3 DOWNTO 0);
      socket_tx_free_out    : OUT    std_logic_vector (16 DOWNTO 0);                 -- 17bit value .. that's true
      trigger_veto          : OUT    std_logic                     := '1';
      w5300_state           : OUT    std_logic_vector (7 DOWNTO 0);                  -- state is encoded here ... useful for debugging.
      wiz_addr              : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs                : OUT    std_logic                     := '1';
      wiz_rd                : OUT    std_logic                     := '1';
      wiz_reset             : OUT    std_logic                     := '1';
      wiz_wr                : OUT    std_logic                     := '1';
      sio                   : INOUT  std_logic ;
      wiz_data              : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT adc_emulator
   GENERIC (
      INPUT_FILE : string := "filename"
   );
   PORT (
      clk  : IN     STD_LOGIC ;
      data : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      otr  : OUT    STD_LOGIC ;
      oeb  : IN     STD_LOGIC 
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 50 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT max6662_emulator
   GENERIC (
      DRS_TEMPERATURE : integer := 51
   );
   PORT (
      sclk      : IN     std_logic ;
      sio       : INOUT  std_logic ;
      sensor_cs : IN     std_logic_vector (3 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT trigger_generator
   GENERIC (
      TRIGGER_RATE : time := 1 ms;
      PULSE_WIDTH  : time := 20 ns
   );
   PORT (
      trigger : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT w5300_emulator
   PORT (
      int  : OUT    std_logic  := '1';
      addr : IN     std_logic_vector (9 DOWNTO 0);
      data : INOUT  std_logic_vector (15 DOWNTO 0);
      rd   : IN     std_logic ;
      cs   : IN     std_logic ;
      wr   : IN     std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   FOR ALL : adc_emulator USE ENTITY FACT_FAD_TB_lib.adc_emulator;
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   FOR ALL : max6662_emulator USE ENTITY FACT_FAD_TB_lib.max6662_emulator;
   FOR ALL : trigger_generator USE ENTITY FACT_FAD_TB_lib.trigger_generator;
   FOR ALL : w5300_emulator USE ENTITY FACT_FAD_TB_lib.w5300_emulator;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb_mainTB_ID
   -- eb_ID 1: hard-wired IDs
   board_id <= "0101";
   crate_id <= "01";

   -- HDL Embedded Text Block 2 eb_mainTB_adc
   -- eb_adc 2: ADC routing
   adc_data_array(0) <= adc_data;
   adc_data_array(1) <= adc_data;
   adc_data_array(2) <= adc_data;
   adc_data_array(3) <= adc_data;
   adc_otr_array(0) <= adc_otr;
   adc_otr_array(1) <= adc_otr;
   adc_otr_array(2) <= adc_otr;
   adc_otr_array(3) <= adc_otr;

   -- HDL Embedded Text Block 3 eb_mainTB_adc1
   
   D_T_in(1 downto 0) <= "00";
   plllock_in(3 downto 0) <= "1111";
   SROUT_in_0 <= '1';
   SROUT_in_1 <= '0';
   SROUT_in_2 <= '1';
   SROUT_in_3 <= '0';


   -- Instance port mappings.
   I_mainTB_FPGA : FAD_main
      GENERIC MAP (
         RAMADDRWIDTH64b => 15
      )
      PORT MAP (
         CLK                   => clk,
         D_T_in                => D_T_in,
         FTM_RS485_rx_d        => FTM_RS485_rx_d,
         SROUT_in_0            => SROUT_in_0,
         SROUT_in_1            => SROUT_in_1,
         SROUT_in_2            => SROUT_in_2,
         SROUT_in_3            => SROUT_in_3,
         adc_data_array        => adc_data_array,
         adc_otr_array         => adc_otr_array,
         board_id              => board_id,
         crate_id              => crate_id,
         drs_refclk_in         => REF_CLK,
         plllock_in            => plllock_in,
         trigger               => trigger,
         wiz_int               => wiz_int,
         ADC_CLK               => ADC_CLK,
         CLK_25_PS             => CLK_25_PS,
         CLK_50                => CLK_50,
         DG_state              => DG_state,
         FTM_RS485_rx_en       => FTM_RS485_rx_en,
         FTM_RS485_tx_d        => FTM_RS485_tx_d,
         FTM_RS485_tx_en       => FTM_RS485_tx_en,
         RSRLOAD               => RSRLOAD,
         SRCLK                 => SRCLK,
         SRIN_out              => SRIN_out,
         adc_oeb               => adc_oeb,
         alarm_refclk_too_high => alarm_refclk_too_high,
         alarm_refclk_too_low  => alarm_refclk_too_low,
         amber                 => amber,
         counter_result        => counter_result,
         dac_cs                => dac_cs,
         debug_data_ram_empty  => debug_data_ram_empty,
         debug_data_valid      => debug_data_valid,
         denable               => denable,
         drs_channel_id        => drs_channel_id,
         drs_dwrite            => drs_dwrite,
         green                 => green,
         led                   => led,
         mem_manager_state     => mem_manager_state,
         mosi                  => mosi,
         red                   => red,
         sclk                  => sclk,
         sensor_cs             => sensor_cs,
         socket_tx_free_out    => socket_tx_free_out,
         trigger_veto          => trigger_veto,
         w5300_state           => w5300_state,
         wiz_addr              => wiz_addr,
         wiz_cs                => wiz_cs,
         wiz_rd                => wiz_rd,
         wiz_reset             => wiz_reset,
         wiz_wr                => wiz_wr,
         sio                   => sio,
         wiz_data              => wiz_data
      );
   I_mainTB_adc : adc_emulator
      GENERIC MAP (
         INPUT_FILE => "../memory_files/analog_input_ch0.txt"
      )
      PORT MAP (
         clk  => ADC_CLK,
         data => adc_data,
         otr  => adc_otr,
         oeb  => adc_oeb
      );
   I_mainTB_clock : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => clk,
         rst => OPEN
      );
   I_mainTB_clock1 : clock_generator
      GENERIC MAP (
         clock_period => 1 us,
         reset_time   => 1 us
      )
      PORT MAP (
         clk => REF_CLK,
         rst => OPEN
      );
   I_mainTB_max6662 : max6662_emulator
      GENERIC MAP (
         DRS_TEMPERATURE => 51
      )
      PORT MAP (
         sclk      => sclk,
         sio       => sio,
         sensor_cs => sensor_cs
      );
   I_mainTB_trigger : trigger_generator
      GENERIC MAP (
         TRIGGER_RATE => 1 ms,
         PULSE_WIDTH  => 20 ns
      )
      PORT MAP (
         trigger => trigger
      );
   I_mainTB_w5300 : w5300_emulator
      PORT MAP (
         int  => wiz_int,
         addr => wiz_addr,
         data => wiz_data,
         rd   => wiz_rd,
         cs   => wiz_cs,
         wr   => wiz_wr
      );

END struct;
