-- VHDL Entity FACT_FAD_TB_lib.FAD_rs485_receiver_tb.symbol
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 13:03:38 10.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--


ENTITY FAD_rs485_receiver_tb IS
-- Declarations

END FAD_rs485_receiver_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.FAD_rs485_receiver_tb.struct
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 13:03:38 10.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
LIBRARY fact_fad_lib;
USE fact_fad_lib.fad_rs485_constants.ALL;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF FAD_rs485_receiver_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL rec_clk             : std_logic;
   SIGNAL rec_dout            : std_logic_vector(RX_WIDTH - 1 DOWNTO 0);
   SIGNAL rec_start           : std_logic;
   SIGNAL rec_timeout_occured : std_logic;
   SIGNAL rec_valid           : std_logic;
   SIGNAL rx_d                : std_logic;
   SIGNAL rx_en               : std_logic;
   SIGNAL tx_d                : std_logic;
   SIGNAL tx_en               : std_logic;


   -- Component Declarations
   COMPONENT FAD_rs485_receiver
   GENERIC (
      RX_BYTES : integer := 7;
      RX_WIDTH : integer := 56
   );
   PORT (
      rec_clk             : IN     std_logic;
      rec_start           : IN     std_logic;
      rx_d                : IN     std_logic;
      rec_dout            : OUT    std_logic_vector (RX_WIDTH - 1 DOWNTO 0) := (others => '0');
      rec_timeout_occured : OUT    std_logic                                := '0';
      rec_valid           : OUT    std_logic                                := '0';
      rx_en               : OUT    std_logic;
      tx_d                : OUT    std_logic;
      tx_en               : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT FAD_rs485_receiver_tester
   PORT (
      rec_dout            : IN     std_logic_vector (RX_WIDTH - 1 DOWNTO 0);
      rec_timeout_occured : IN     std_logic ;
      rec_valid           : IN     std_logic ;
      rx_en               : IN     std_logic ;
      tx_d                : IN     std_logic ;
      tx_en               : IN     std_logic ;
      rec_start           : OUT    std_logic ;
      rx_d                : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 50 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_rs485_receiver USE ENTITY FACT_FAD_lib.FAD_rs485_receiver;
   FOR ALL : FAD_rs485_receiver_tester USE ENTITY FACT_FAD_TB_lib.FAD_rs485_receiver_tester;
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   U_0 : FAD_rs485_receiver
      GENERIC MAP (
         -- defined in fad_rs485_definitions.fad_rs485_constants
         RX_BYTES => 7,         -- no. of bytes to receive
         RX_WIDTH => 56         -- no. of bits to receive
      )
      PORT MAP (
         rec_clk             => rec_clk,
         rx_d                => rx_d,
         rx_en               => rx_en,
         tx_d                => tx_d,
         tx_en               => tx_en,
         rec_start           => rec_start,
         rec_timeout_occured => rec_timeout_occured,
         rec_dout            => rec_dout,
         rec_valid           => rec_valid
      );
   U_1 : FAD_rs485_receiver_tester
      PORT MAP (
         rec_dout            => rec_dout,
         rec_timeout_occured => rec_timeout_occured,
         rec_valid           => rec_valid,
         rx_en               => rx_en,
         tx_d                => tx_d,
         tx_en               => tx_en,
         rec_start           => rec_start,
         rx_d                => rx_d
      );
   U_2 : clock_generator
      GENERIC MAP (
         clock_period => 50 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => rec_clk,
         rst => OPEN
      );

END struct;
