-- VHDL Entity FACT_FAD_TB_lib.led_controller_tb.symbol
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 10:21:57 02.03.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--


ENTITY led_controller_tb IS
   GENERIC( 
      HEARTBEAT_PWM_DIVIDER : integer := 500;
      WAITING_DIVIDER       : integer := 500000000
   );
-- Declarations

END led_controller_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.led_controller_tb.struct
--
-- Created:
--          by - daqct3.UNKNOWN (IHP110)
--          at - 10:21:58 02.03.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.STD_LOGIC_UNSIGNED.ALL;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.ALL;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF led_controller_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK                    : std_logic;
   SIGNAL additional_flasher_out : std_logic;
   SIGNAL amber                  : std_logic;
   SIGNAL green                  : std_logic;
   SIGNAL red                    : std_logic;
   SIGNAL refclk_too_high        : std_logic;
   SIGNAL refclk_too_low         : std_logic;
   SIGNAL socks_connected        : std_logic;
   SIGNAL socks_waiting          : std_logic;
   SIGNAL trigger                : std_logic;


   -- Component Declarations
   COMPONENT led_controller
   GENERIC (
      HEARTBEAT_PWM_DIVIDER : integer := 500;
      WAITING_DIVIDER       : integer := 500000000
   );
   PORT (
      CLK                    : IN     std_logic;
      refclk_too_high        : IN     std_logic;
      refclk_too_low         : IN     std_logic;
      socks_connected        : IN     std_logic;
      socks_waiting          : IN     std_logic;
      trigger                : IN     std_logic;
      additional_flasher_out : OUT    std_logic;
      amber                  : OUT    std_logic;
      green                  : OUT    std_logic;
      red                    : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 20 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT led_controller_tester
   PORT (
      additional_flasher_out : IN     std_logic ;
      amber                  : IN     std_logic ;
      green                  : IN     std_logic ;
      red                    : IN     std_logic ;
      refclk_too_high        : OUT    std_logic ;
      refclk_too_low         : OUT    std_logic ;
      socks_connected        : OUT    std_logic ;
      socks_waiting          : OUT    std_logic ;
      trigger                : OUT    std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   FOR ALL : led_controller USE ENTITY FACT_FAD_lib.led_controller;
   FOR ALL : led_controller_tester USE ENTITY FACT_FAD_TB_lib.led_controller_tester;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   led_controller_instance : led_controller
      GENERIC MAP (
         HEARTBEAT_PWM_DIVIDER => 500,
         WAITING_DIVIDER       => 500000000
      )
      PORT MAP (
         CLK                    => CLK,
         green                  => green,
         amber                  => amber,
         red                    => red,
         additional_flasher_out => additional_flasher_out,
         trigger                => trigger,
         refclk_too_high        => refclk_too_high,
         refclk_too_low         => refclk_too_low,
         socks_waiting          => socks_waiting,
         socks_connected        => socks_connected
      );
   U_2 : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => CLK,
         rst => OPEN
      );
   U_1 : led_controller_tester
      PORT MAP (
         additional_flasher_out => additional_flasher_out,
         amber                  => amber,
         green                  => green,
         red                    => red,
         refclk_too_high        => refclk_too_high,
         refclk_too_low         => refclk_too_low,
         socks_connected        => socks_connected,
         socks_waiting          => socks_waiting,
         trigger                => trigger
      );

END struct;
