-- VHDL Entity FACT_FAD_TB_lib.phase_shifter_tb.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 13:16:36 14.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--


ENTITY phase_shifter_tb IS
-- Declarations

END phase_shifter_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.phase_shifter_tb.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 13:16:36 14.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF phase_shifter_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL LOCKED      : std_logic;
   SIGNAL PSCLK       : std_logic;
   SIGNAL PSDONE      : std_logic;
   SIGNAL PSEN        : std_logic;
   SIGNAL PSINCDEC    : std_logic;
   SIGNAL clk         : std_logic;
   SIGNAL direction   : std_logic;
   SIGNAL offset      : std_logic_vector(7 DOWNTO 0);
   SIGNAL ready       : std_logic;
   SIGNAL reset_DCM   : std_logic;
   SIGNAL rst         : std_logic;
   SIGNAL shift_phase : std_logic;
   SIGNAL shifting    : std_logic;


   -- Component Declarations
   COMPONENT phase_shifter
   PORT (
      CLK         : IN     std_logic ;
      rst         : OUT    std_logic                     := '0'; --asynch in of DCM
      -- interface to: clock_generator_variable_PS_struct.vhd
      PSCLK       : OUT    std_logic ;
      PSEN        : OUT    std_logic                     := '0';
      PSINCDEC    : OUT    std_logic                     := '1'; -- default is 'incrementing'
      PSDONE      : IN     std_logic ;                           -- will pulse once, if phase shifting was done.
      LOCKED      : IN     std_logic ;                           -- when is this going high?
      -- interface to: w5300_modul.vhd
      shift_phase : IN     std_logic ;
      direction   : IN     std_logic ;                           -- corresponds TO 'PSINCDEC'
      reset_DCM   : IN     std_logic ;                           -- asynch in: orders us, TO reset the DCM
      -- status:
      shifting    : OUT    std_logic                     := '0';
      ready       : OUT    std_logic                     := '0';
      offset      : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0')
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 20 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT phase_shifter_tester
   PORT (
      clk         : IN     std_logic ;
      PSCLK       : IN     std_logic ;
      PSEN        : IN     std_logic ;
      PSINCDEC    : IN     std_logic ;
      offset      : IN     std_logic_vector (7 DOWNTO 0);
      ready       : IN     std_logic ;
      rst         : IN     std_logic ;
      shifting    : IN     std_logic ;
      LOCKED      : OUT    std_logic ;
      PSDONE      : OUT    std_logic ;
      direction   : OUT    std_logic ;
      reset_DCM   : OUT    std_logic ;
      shift_phase : OUT    std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   FOR ALL : phase_shifter USE ENTITY FACT_FAD_lib.phase_shifter;
   FOR ALL : phase_shifter_tester USE ENTITY FACT_FAD_TB_lib.phase_shifter_tester;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   U_0 : phase_shifter
      PORT MAP (
         CLK         => clk,
         rst         => rst,
         PSCLK       => PSCLK,
         PSEN        => PSEN,
         PSINCDEC    => PSINCDEC,
         PSDONE      => PSDONE,
         LOCKED      => LOCKED,
         shift_phase => shift_phase,
         direction   => direction,
         reset_DCM   => reset_DCM,
         shifting    => shifting,
         ready       => ready,
         offset      => offset
      );
   U_2 : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => clk,
         rst => OPEN
      );
   U_1 : phase_shifter_tester
      PORT MAP (
         clk         => clk,
         PSCLK       => PSCLK,
         PSEN        => PSEN,
         PSINCDEC    => PSINCDEC,
         offset      => offset,
         ready       => ready,
         rst         => rst,
         shifting    => shifting,
         LOCKED      => LOCKED,
         PSDONE      => PSDONE,
         direction   => direction,
         reset_DCM   => reset_DCM,
         shift_phase => shift_phase
      );

END struct;
