--
-- VHDL Architecture FACT_FAD_TB_lib.phase_shifter_tester.beha
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 14:39:41 12.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.ALL;

ENTITY phase_shifter_tester IS
   PORT( 
      -- interface to: clock_generator_variable_PS_struct.vhd
      
      clk:in std_logic;
      
      
      PSCLK       : IN     std_logic;
      PSEN        : IN     std_logic;
      PSINCDEC    : IN     std_logic;                      -- default is 'incrementing'
      offset      : IN     std_logic_vector (7 DOWNTO 0);
      ready       : IN     std_logic;
      rst         : IN     std_logic;                      --asynch in of DCM
      -- status:
      shifting    : IN     std_logic;
      LOCKED      : OUT    std_logic;                      -- when is this going high?
      PSDONE      : OUT    std_logic;                      -- will pulse once, if phase shifting was done.
      direction   : OUT    std_logic;                      -- corresponds to 'PSINCDEC'
      reset_DCM   : OUT    std_logic;                      -- asynch in: orders us, to reset the DCM
      -- interface to: w5300_modul.vhd
      shift_phase : OUT    std_logic
   );

-- Declarations

END phase_shifter_tester ;

--
ARCHITECTURE beha OF phase_shifter_tester IS
constant DIVIDER : integer  := 25;
	signal bla : std_logic := '0';
	signal  Z: integer range 0 to DIVIDER - 1;
	signal  Y: integer range 0 to DIVIDER - 1;
	signal ping : std_logic := '0';
	signal locken : std_logic := '1';
BEGIN

LOCKED <= '1' and locken;

	
	process
		begin
			direction <= '1';
			shift_phase <='0';			
			reset_DCM <= '0';
			
			
			
			wait for 1us;
			shift_phase <='1';			
			wait for 100ns;
			shift_phase <='0';
      wait for 1us;
      shift_phase <='1';			
      wait for 100ns;
      shift_phase <='0';
      wait for 1us;
      shift_phase <='1';			
      wait for 100ns;
      shift_phase <='0';

      wait for 1us;
      reset_DCM <='1';			
      wait for 500ns;
      reset_DCM <='0';
      
	end process;
	
	-- DCM PSDONE simulation
	-- after DCM receives PSEN high it will start shifting and then .. after a while rise PSDONE for 1 cycle.
	-- let's see how to simulate this here.

			clk_proc: process (clk)

			begin
				
				if rising_edge(clk) then
					if (PSEN = '1') then 
						bla <= '1';
					end if;
					
				if (bla = '1') then
					if (Z < DIVIDER - 1) then 
						Z <= Z + 1;
					else 
						Z <= 0;
						bla <= '0';	
					end if;
					if (Z = 0) then 
						PSDONE <= '0';	
					end if;
					if (Z = DIVIDER -2 ) then 
						PSDONE <= '1';

					end if;
					if (Z = DIVIDER -1 ) then 
						PSDONE <= '0';

					end if;

				end if; --bla =1

				end if;
			end process clk_proc;

			process (clk)
			begin
				if (rst = '1') then 
									ping <= '1';
									locken <= '0';
				end if;

								if rising_edge(clk) then					
									if (ping = '1') then
												if (Y < DIVIDER - 1) then 
													Y <= Y + 1;
												else 
													Y <= 0;
													ping <= '0';	
												end if;
									
									
									if (Y = DIVIDER -1 ) then 
										locken <= '1';

					end if;

				end if; --bla =1

				end if;
			end process;

			


END ARCHITECTURE beha;

