-- VHDL Entity FACT_FAD_TB_lib.spi_max6662_tb.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 19:20:17 03.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--


ENTITY spi_max6662_tb IS
   GENERIC( 
      SPI_CLK_DIVIDER : integer := 25;
      SCLK_CYCLES     : integer := 24
   );
-- Declarations

END spi_max6662_tb ;

--
-- VHDL Architecture FACT_FAD_TB_lib.spi_max6662_tb.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 19:20:17 03.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_unsigned.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF spi_max6662_tb IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CS                 : std_logic;
   SIGNAL MOSI               : std_logic := '0';
   SIGNAL SCLK               : std_logic;
   SIGNAL busy               : std_logic;
   SIGNAL clk                : std_logic;
   SIGNAL data               : std_logic_vector(15 DOWNTO 0);
   SIGNAL read_temp_register : std_logic;
   SIGNAL ready              : std_logic;
   SIGNAL sensor_cs          : std_logic_vector(3 DOWNTO 0);
   SIGNAL sio                : std_logic;


   -- Component Declarations
   COMPONENT spi_max6662
   PORT (
      clk                : IN     std_logic;
      read_temp_register : IN     std_logic;
      CS                 : OUT    std_logic                      := '1';
      MOSI               : OUT    std_logic                      := '0';
      SCLK               : OUT    std_logic                      := '0';
      busy               : OUT    std_logic                      := '1';
      data               : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      ready              : OUT    std_logic                      := '0';
      MISO               : INOUT  std_logic                      := 'Z'
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 20 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    std_logic  := '0';
      rst : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT max6662_emulator
   GENERIC (
      DRS_TEMPERATURE : integer := 51
   );
   PORT (
      sclk      : IN     std_logic ;
      sio       : INOUT  std_logic ;
      sensor_cs : IN     std_logic_vector (3 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT spi_max6662_tester
   PORT (
      CS                 : IN     std_logic ;
      MOSI               : IN     std_logic ;
      SCLK               : IN     std_logic ;
      busy               : IN     std_logic ;
      data               : IN     std_logic_vector (15 DOWNTO 0);
      ready              : IN     std_logic ;
      read_temp_register : OUT    std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   FOR ALL : max6662_emulator USE ENTITY FACT_FAD_TB_lib.max6662_emulator;
   FOR ALL : spi_max6662 USE ENTITY FACT_FAD_lib.spi_max6662;
   FOR ALL : spi_max6662_tester USE ENTITY FACT_FAD_TB_lib.spi_max6662_tester;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb1
   sensor_cs <= (CS,CS,CS,CS);                                    


   -- Instance port mappings.
   U_0 : spi_max6662
      PORT MAP (
         clk                => clk,
         SCLK               => SCLK,
         CS                 => CS,
         MOSI               => MOSI,
         MISO               => sio,
         read_temp_register => read_temp_register,
         data               => data,
         ready              => ready,
         busy               => busy
      );
   --   synthesis translate_off
   U_2 : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => clk,
         rst => OPEN
      );
   U_3 : max6662_emulator
      GENERIC MAP (
         DRS_TEMPERATURE => 51
      )
      PORT MAP (
         sclk      => SCLK,
         sio       => sio,
         sensor_cs => sensor_cs
      );
   U_1 : spi_max6662_tester
      PORT MAP (
         CS                 => CS,
         MOSI               => MOSI,
         SCLK               => SCLK,
         busy               => busy,
         data               => data,
         ready              => ready,
         read_temp_register => read_temp_register
      );

END struct;
