--
-- VHDL Architecture FACT_FAD_TB_lib.timer_tester.beha
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 15:31:09 22.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_unsigned.all;

ENTITY timer_tester IS
   PORT( 
      synched_o : IN     std_logic;
      time_o    : IN     std_logic_vector ( 31 DOWNTO 0);
      enable_i  : OUT    std_logic;
	  reset_synch_i : OUT    std_logic;
	  clk : OUT    std_logic;
      synch_i   : OUT    std_logic
   );

-- Declarations

END timer_tester ;

--
ARCHITECTURE beha OF timer_tester IS
	constant clock_period : time := 20 ns;
BEGIN
	clock_gen_proc: process
	begin
		clk <= '0';
		wait for clock_period / 2;
		clk <= '1';
		wait for clock_period / 2;
	end process clock_gen_proc;

	process begin
		enable_i <= '0';
		synch_i <= '0';
		reset_synch_i <= '0';
		wait for 105 ns;
		enable_i <= '1';
		wait for 950 us;
		wait for 7 ns;
		synch_i <='1';
		wait for 20 ns;
		synch_i <= '0';
		wait for 1 ms;
		wait for 7 ns;
		synch_i <='1';
		wait for 20 ns;
		synch_i <= '0';
		wait for 1 ms;
		reset_synch_i <= '1';
		wait for 20 ns;
		reset_synch_i <= '0';
		wait for 1 ms;
		synch_i <='1';
		wait for 20 ns;
		synch_i <= '0';
		wait for 1 ms;
		enable_i <= '0';
		wait;
	end process;
	
END ARCHITECTURE beha;

