
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

ENTITY w5300_emulator IS
	PORT(
		int : out 	std_logic := '1';
		addr : in     std_logic_vector (9 DOWNTO 0);
		data : inout  std_logic_vector (15 DOWNTO 0);
		rd   : in     std_logic;
		cs   : in     std_logic;
		wr   : in     std_logic
	);
END w5300_emulator ;

architecture beha of w5300_emulator is
	
	signal open_done : std_logic_vector(7 downto 0) := (others => '0');
	signal data_temp : std_logic_vector(15 downto 0);
	signal RSR_0, RSR_1  : std_logic_vector (15 downto 0);
	signal FIFOR_CNT : integer := 0;
	
	signal cs_sr : std_logic_vector( 1 downto 0 ) := "00";
	signal rd_sr : std_logic_vector( 1 downto 0 ) := "00";
	signal wr_sr : std_logic_vector( 1 downto 0 ) := "00";
	type state_type is (
		INIT,
	);
	signal state : state_type := INIT;
	
begin  
  data <= data_temp when (rd = '0') else (others => 'Z');
  data_temp <= data when (wr = '0') else (others => 'Z');
  
  new_proc : process (clk)
  begin
	if rising_edge(clk) then
		cs_sr <= cs_sr(0) & cs;
		rd_sr <= rd_sr(0) & rd;
		wr_sr <= wr_sr(0) & wr;
		
		case state is
		when OPENED =>
			if (addr = conv_integer(W5300_S0_SSR) + i * 64) then
				data_temp <= X"0013";
			end if;
			
		WHEN ESTABLISHED =>
			if (addr = conv_integer(W5300_S0_SSR) + i * 64) then
				data_temp <= X"0017";
			end if;
		
		
		
		end case; --state
	end if; -- rising_edge(clk)
  end process new_proc;
  
  set_proc : process
  begin
	FIFOR_CNT <= 0;
    RSR_0 <= X"0000";
    RSR_1 <= X"0000";
    wait for 150 us;
    RSR_1 <= X"0001";
    wait for 100 us;
    RSR_1 <= X"0002";
    wait for 500 us;
		FIFOR_CNT <= 1;
	wait for 100 us;
		FIFOR_CNT <= 2;
	wait for 200 us;
		FIFOR_CNT <= 3;
	wait for 200 ns;
		RSR_1 <= X"0000";
	wait for 2 ms;
		RSR_1 <= X"0002";
		FIFOR_CNT <= 2;
		
	wait for 6 ms;
	int <= '0';
	 
--	wait for 1 ms;
--		RSR_1 <= X"0000";
--		FIFOR_CNT <= 3;
    wait;
  end process set_proc;

  w5300_proc : process (addr)
  begin
    for i in 0 to 7 loop
      if (addr = conv_integer(W5300_S0_SSR) + i * 64) then
        if (open_done(i) = '0') then
          data_temp <= X"0013";
          open_done(i) <= '1';
        else
          data_temp <= X"0017";
        end if;
      elsif (addr = conv_integer(W5300_S0_TX_FSR) + i * conv_integer(W5300_S_INC)) then
        data_temp <= X"0000";
      elsif (addr = conv_integer(W5300_S0_TX_FSR + 2) + i * conv_integer(W5300_S_INC)) then
        data_temp <= X"3C00";
      elsif (addr = conv_integer(W5300_S0_RX_RSR)) then
        data_temp <= RSR_0;
      elsif (addr = conv_integer(W5300_S0_RX_RSR) + 2) then
        data_temp <= RSR_1;
      elsif (addr = conv_integer(W5300_S0_RX_FIFOR)) then
        if (FIFOR_CNT = 0) then
          data_temp <= X"1800";
          
        elsif (FIFOR_CNT = 1) then
          data_temp <= X"2200";
          
        elsif (FIFOR_CNT = 2) then
          data_temp <= X"A000";
         

	  elsif (FIFOR_CNT = 3) then
		data_temp <= X"A000";
	  end if;
      else
        null;
      end if;
    end loop;
  end process w5300_proc;

  
end architecture beha;