
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

ENTITY clk_divider IS
   GENERIC( 
      DIVIDER : integer := 25  
   );
   PORT( 
      clk  : IN     std_logic;
      sclk : OUT    std_logic  := '0'
   );
END clk_divider ;

ARCHITECTURE beha OF clk_divider IS
  
BEGIN
  
  clk_proc: process (clk)
    variable Z: integer range 0 to DIVIDER - 1;
  begin
    if rising_edge(clk) then
      if (Z < DIVIDER - 1) then 
        Z := Z + 1;
      else 
        Z := 0;
      end if;
      if (Z = 0) then 
        sclk <= '1';
      end if;
      if (Z = DIVIDER / 2) then 
        sclk <= '0';
      end if;
    end if;
  end process clk_proc;

END ARCHITECTURE beha;
