LIBRARY ieee;
USE ieee.std_logic_1164.all;
--USE ieee.std_logic_arith.all;
--use ieee.STD_LOGIC_UNSIGNED.all;
use ieee.numeric_std.all;

library FACT_FAD_lib;
use FACT_FAD_lib.fad_definitions.all;


ENTITY continous_pulser IS

GENERIC( 
  MINIMAL_TRIGGER_WAIT_TIME : integer := 250000;
  TRIGGER_WIDTH : integer := 5
);
PORT(
    CLK : IN std_logic; -- 25MHz = 40ns
    enable : in std_logic;
    multiplier : IN std_logic_vector (15 downto 0);
    trigger : out std_logic 
  );
END ENTITY continous_pulser;

ARCHITECTURE beha OF continous_pulser IS
  
--  type states is ( INIT, WAITING, CONNECTED); 
--    signal state,next_state : states := INIT;
  
  -- noninverted logic
  signal trigger_loc : std_logic := '0';
  signal mult_int : integer range 0 to 65535 :=0;
  signal prescaler: integer range 0 to (MINIMAL_TRIGGER_WAIT_TIME);
  signal scaler: integer range 0 to 256;

BEGIN
  trigger <= trigger_loc and enable;

counter : process (CLK)
    
  begin
    if rising_edge(CLK) then
      mult_int <= to_integer(unsigned(multiplier));


      if (prescaler < MINIMAL_TRIGGER_WAIT_TIME - 1) then 
        prescaler <= prescaler + 1;
      else
        prescaler <= 0;
        if ( scaler < mult_int ) then 
          scaler <= scaler + 1;
        else 
          scaler <= 0;
        end if;
      end if;
      
      if ( (prescaler = 0)and(scaler = 0) ) then 
        trigger_loc <= '1';
      end if;
      if (prescaler = TRIGGER_WIDTH) then 
        trigger_loc <= '0';
      end if;
    end if;
  end process counter; 

END ARCHITECTURE beha;