----------------------------------------------------------------------------------
-- Company:        TU Dortmund, Lehrstuhl fuer experimentelle Physik 5b, Astroteilchenphysik 
-- Engineer:       D.Neise
-- 
-- Create Date:    April 2011
-- Design Name:    
-- Module Name:    fad_rs485_definitions
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    library file for FAD design										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- 
-- Additional Comments: 
--	Many thanks to Q. Weitzel
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
-- use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package fad_rs485_constants is

  constant FAD_RS485_INPUT_CLK_F : integer := 50000000;		-- 50MHz
  --communication with FTM
  constant RS485_BAUD_RATE			: integer := 250000;  	-- bits / sec in our case
  constant RS485_MESSAGE_LEN_BYTES	: integer := 7;			-- @250kbaud --> 308us in total or (@50Mhz) 15400 clk cycles.
  -- notes about the timeout:
  -- the timeout is measured *after* the receiption of the 1st byte ... not after the 1st startbit.
  -- one byte consists of 1 startbit, 8 databits, 2 stopbit2 --> 11 bits in total.
  -- in order to have some ~10% contingency, we decided to put 13 bits instead of 11
  --
  -- so this timeout evaluates to 18200 clk cycles or 364us *after* the 1st byte was received.
  -- this means, one message is trunkated only, if it is longer than ~356us in total.
  -- this might be subject to changes.
  -- keep in mind that, there is an additional timeout 
  constant RS485_TIMEOUT			: integer := (RS485_MESSAGE_LEN_BYTES * 13) * (FAD_RS485_INPUT_CLK_F / RS485_BAUD_RATE);   

end fad_rs485_constants;
