--
-- VHDL Architecture FACT_FAD_TB_lib.trigger_counter.beha
--
-- Created:
--          by - FPGA_Developer.UNKNOWN (EEPC8)
--          at - 14:36:14 10.02.2010
--
-- using Mentor Graphics HDL Designer(TM) 2008.1 (Build 17)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;


entity trigger_counter is
  port(
    trigger_id : out std_logic_vector(31 downto 0);
    trigger : in std_logic;
    reset : in std_logic;
    clk : in std_logic
  );
    
end entity trigger_counter;

architecture beha of trigger_counter is
  
  signal trigger_sr : std_logic_vector (1 downto 0) := "00";
  signal reset_sr : std_logic_vector (1 downto 0) := "00";
  signal temp_id : integer := 0;
  
begin
  
  trigger_id <= conv_std_logic_vector(temp_id, 32);
  
  trigger_incr_proc: process(clk)
  begin
    if rising_edge(clk) then
      reset_sr <= reset_sr(0) & reset;
      trigger_sr <= trigger_sr(0) & trigger;
      if (trigger_sr = "01") then
        temp_id <= temp_id + 1;
      end if;
      if (reset_sr = "01") then
        temp_id <= 0;
      end if;
    end if;
  end process trigger_incr_proc;
  
end architecture beha;

