--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use std.textio.all;
--use work.txt_util.all;
-- use IEEE.NUMERIC_STD.ALL;

package fad_definitions is

  
-- Declare constants

  type mac_type is array (0 to 2) of std_logic_vector (15 downto 0);
  type ip_type is array (0 to 3) of integer;
  
  type mac_list_type is array (0 to 2) of mac_type;
  type ip_list_type is array (0 to 2) of ip_type;
-- Network Settings

  constant ETHZ_GATEWAY : ip_type := (192, 33, 96, 1);
  constant CAM_GATEWAY : ip_type := (192, 33, 96, 1); --???????????????
  constant TUDO_GATEWAY : ip_type := (129, 217, 160, 1);  
  
  constant ETHZ_NETMASK : ip_type := (255, 255, 248, 0);
  constant CAM_NETMASK : ip_type := (255, 255, 248, 0);  --???????????????
  constant TUDO_NETMASK : ip_type := (255, 255, 255, 0);

  --constant MAC_ZERO : mac_type := (X"0000", X"0000", X"0000");
  constant MAC_FAD0 : mac_type := (X"0011", X"9561", X"97B4"); 
  constant MAC_FAD1 : mac_type := (X"FAC7", X"0FAD", X"0001"); 
  constant MAC_FAD2 : mac_type := (X"FAC7", X"0FAD", X"0002"); 
  
  --constant IP_ZERO : ip_type := (0,0,0,0);
  constant IP_TUDO : ip_type := (129, 217, 160, 119);
  constant IP_ETHZ_FAD0 : ip_type := (192, 33, 99, 225);
  constant IP_ETHZ_FAD1 : ip_type := (192, 33, 99, 226);
  constant IP_ETHZ_FAD2 : ip_type := (192, 33, 99, 237);

  -- IP lookup table used to convert CID,BID into IP, if not in camera.
  constant IP_LIST : ip_list_type := (IP_ETHZ_FAD0, IP_ETHZ_FAD1, IP_ETHZ_FAD2);    
  constant MAC_LIST : mac_list_type := (MAC_FAD0,MAC_FAD1,MAC_FAD2);

  constant FIRST_PORT : integer := 31919;
  constant CAM_IP_PREFIX : ip_type := (10, 0, 0, 0);
  constant IP_offset : integer := 128;
  constant CAM_MAC_prefix : mac_type := (X"FAC7", X"0FAD", X"0000"); 
-- Network Settings End  
	--constant SUBVERSION_LONGSTRING : string := "$Rev: 11173 $::           $";
	--constant SUBVERSION_STRING : string := SUBVERSION_LONGSTRING(7 to 25); -- cut off starting "$Rev: 11173 $:: " and trailing "$"
	--constant SUBVERSION_NUMBER : std_logic_vector (15 downto 0) := conv_std_logic_vector(str_to_int(SUBVERSION_STRING),16);
	constant PACKAGE_VERSION : std_logic_vector(7 downto 0) := X"02";
	constant PACKAGE_SUB_VERSION : std_logic_vector(7 downto 0) := X"13";
	constant PACKAGE_HEADER_LENGTH : integer := 36;
	constant PACKAGE_HEADER_ZEROS : integer := 0;  
	constant PACKAGE_END_LENGTH : integer := 2; -- CRC and END-Flag
	constant PACKAGE_END_ZEROS : integer := 2;
	constant CHANNEL_HEADER_SIZE : integer := 4; 
	constant NUMBER_OF_DRS : integer := 4; 
	constant POSITION_OF_ROI_IN_CHANNEL_HEADER : integer := 3;

  constant W5300_S_INC : std_logic_vector(6 downto 0) := "1000000"; -- socket address offset

-- W5300 Registers
	constant W5300_BASE_ADR : std_logic_vector (9 downto 0) := (others => '0'); 
	constant W5300_MR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"0";
	constant W5300_IR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2";
	constant W5300_IMR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"4";
	constant W5300_SHAR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"8";
	constant W5300_GAR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"10";
	constant W5300_SUBR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"14";
	constant W5300_SIPR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"18";
	constant W5300_RTR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"1C";
	constant W5300_RCR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"1E";
	constant W5300_TMS01R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"20";
	constant W5300_TMS23R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"22";
  constant W5300_TMS45R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"24";
  constant W5300_TMS67R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"26";
  constant W5300_RMS01R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"28";
  constant W5300_RMS23R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2A";
  constant W5300_RMS45R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2C";
  constant W5300_RMS67R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2E";        	
  constant W5300_MTYPER : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"30";
	
	constant W5300_S0_MR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"0";
	constant W5300_S0_CR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"2";
	constant W5300_S0_IMR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"4";
	constant W5300_S0_IR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"6";
	constant W5300_S0_SSR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"8";
	constant W5300_S0_PORTR 	: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"A";
	constant W5300_S0_DPORTR 	: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"12";
	constant W5300_S0_DIPR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"14";
	  constant W5300_S0_KPALVTR  : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"1A";  -- HIGH byte is S0_KPALVTR register 
	constant W5300_S0_TX_WRSR 	: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"20";
	constant W5300_S0_TX_FSR 	: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"24";
  constant W5300_S0_RX_RSR 		: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"28";
	constant W5300_S0_TX_FIFOR 	: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"2E";
  constant W5300_S0_RX_FIFOR 	: std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"30";
-- End W5300 registers	

-- START W5300 Socket State Codes
  constant SOCKET_CLOSED 	: std_logic_vector (7 downto 0) := X"00";

-- 
  constant W5300_TX_FIFO_SIZE_8B : integer := 15360; -- Socket TX FIFO-Size in Bytes
  constant W5300_TX_FIFO_SIZE : integer := (W5300_TX_FIFO_SIZE_8B / 2); -- Socket TX FIFO-Size in 16 Bit Words

  constant LOG2_OF_RAM_SIZE_64B : integer := 15;
  --constant RAM_SIZE_64B : integer := 2**LOG2_OF_RAM_SIZE_64B;
  constant RAM_SIZE_64B : integer := 24576;
  constant RAM_SIZE_16B : integer := RAM_SIZE_64B * 4;

-- TYPE definitions
	type roi_max_type is array (0 to 8) of std_logic_vector (10 downto 0);
	type roi_array_type is array (0 to 35) of integer range 0 to 1024;
  
  type drs_s_cell_array_type is array (0 to 3) of std_logic_vector (9 downto 0);
  type adc_data_array_type is array (0 to 3) of std_logic_vector (11 downto 0);

  type dac_array_type is array (0 to 7) of integer range 0 to 2**16 - 1;
  type sensor_array_type is array (0 to 3) of integer range 0 to 2**16 - 1;
  
--  constant DEFAULT_ROI : roi_array_type := (115, 125, 100, 102, 155, 101,   0, 101, 106, 
--                                            181, 121, 189, 101, 101, 187,  56, 187, 101,
--                                              2, 141, 101, 100,  10, 100, 178, 101, 174, 
--                                             12, 181, 100, 102, 101, 102,   0, 101, 108); 
--  constant DEFAULT_ROI : roi_array_type := (others => 100);
  constant DEFAULT_ROI : roi_array_type := (others => 1024);
  
  constant DEFAULT_DAC : dac_array_type := (20972, 34079, 20526, 0, 28836, 28836, 28836, 28836);
  --constant DEFAULT_DAC : dac_array_type := (others => 0);
  
  constant DEFAULT_DRSADDR : std_logic_vector (3 downto 0):= "0000";
  constant DEFAULT_DRSADDR_MODE : std_logic := '0';

-- config RAM addresses
constant BADDR_ROI : std_logic_vector 				:= X"00"; -- Baseaddress ROI-Values
constant BADDR_DAC : std_logic_vector 				:= X"24"; -- Baseaddress DAC-Values

	

-- Commands
constant CMD_EXECUTE : std_logic_vector       		:= X"04";   --new
constant CMD_WRITE : std_logic_vector       		:= X"05";
constant CMD_DENABLE : std_logic_vector     		:= X"06";
constant CMD_DDISABLE : std_logic_vector    		:= X"07";
constant CMD_DWRITE_RUN : std_logic_vector  		:= X"08";
constant CMD_DWRITE_STOP : std_logic_vector 		:= X"09";
constant CMD_READ : std_logic_vector        		:= X"0A";
constant CMD_SCLK_ON : std_logic_vector     		:= X"10";
constant CMD_SCLK_OFF : std_logic_vector    		:= X"11";
constant CMD_PS_DIRINC : std_logic_vector   		:= X"12";
constant CMD_PS_DIRDEC : std_logic_vector   		:= X"13";
constant CMD_PS_DO : std_logic_vector     			:= X"14";
constant CMD_SRCLK_ON : std_logic_vector    		:= X"15";
constant CMD_SRCLK_OFF : std_logic_vector   		:= X"16";
constant CMD_PS_RESET : std_logic_vector    		:= X"17";
constant CMD_TRIGGERS_ON : std_logic_vector 		:= X"18";
constant CMD_TRIGGERS_OFF : std_logic_vector		:= X"19";

constant CMD_RESET_TRIGGER_ID : std_logic_vector   	:= X"2A";

constant CMD_START : std_logic_vector       		:= X"22";		-- set data generator in RUN-mnode
constant CMD_STOP : std_logic_vector        		:= X"23";		-- set data generator in STOP-mode
constant CMD_MODE_COMMAND : std_logic_vector        := X"30";
constant CMD_MODE_ALL_SOCKETS : std_logic_vector    := X"31";

constant CMD_MANUAL_BUSY_ON  : std_logic_vector    	:= X"32";
constant CMD_MANUAL_BUSY_OFF  : std_logic_vector    := X"33";

constant CMD_TRIGGER : std_logic_vector     		:= X"A0";
constant CMD_TRIGGER_C : std_logic_vector   		:= X"1F";		-- should be 1F in next revision .. T.B. wants it.
constant CMD_TRIGGER_S : std_logic_vector   		:= X"20";

constant CMD_BUSY_ON : std_logic_vector   		:= X"24";
constant CMD_BUSY_OFF : std_logic_vector   		:= X"25";

constant CMD_STATUS : std_logic_vector			:= X"FF";



-- DRS Registers
  constant DRS_ADDR_IDLE : std_logic_vector := "1001";
  constant DRS_CONFIG_REG : std_logic_vector := "1100";  
  constant DRS_WRITE_SHIFT_REG : std_logic_vector := "1101";  
  constant DRS_WRITE_CONFIG_REG : std_logic_vector := "1110";  
  constant DRS_DISABLE_ALL_OUTS : std_logic_vector := "1111";  
  
-- Declare functions and procedure


constant TIME_UNTIL_READ_READY : integer := 4;
constant TIME_UNTIL_WRITE_READY : integer := 4;


--	FUNCTION wait_if_started ( 
--		signal sr : std_logic_vector(2 downto 0)
--		) RETURN std_logic;
--


-- for W5300 modul2
constant W5300_RAM_ADDR_WIDTH : integer := 17;
constant TX_FIFO_MAX_FREE : std_logic_vector(16 downto 0) := conv_std_logic_vector(15360 ,17); 

-- not needed
--constant ADC_DATA_OFFSET_ADDR : std_logic_vector (W5300_RAM_ADDR_WIDTH-1 downto 0) := conv_std_logic_vector ( 36  , W5300_RAM_ADDR_WIDTH); 


end fad_definitions;

--PACKAGE BODY fad_definitions is
--
--	FUNCTION wait_if_started ( 
--		signal sr : std_logic_vector(2 downto 0)
--		) RETURN std_logic IS
--		
--	BEGIN
--	
--	
--	
--	END FUNCTION wait_if_started;
--		
--
--END fad_definitions;