#ifndef FACT_DataCalib
#define FACT_DataCalib

#include "DataProcessorImp.h"

using namespace std;
#include "DrsCalib.h"

class DimDescribedService;

class DataCalib : public DataProcessorImp, CalibData
{
    static std::vector<int32_t> fOffset;  /// Storage for physical baseline
    static std::vector<int64_t> fGain;    /// Storage for baseline corrected gain
    static std::vector<int64_t> fTrgOff;  /// Storage for logical baseline

    static uint64_t fNumOffset;           /// Scale for physcial baseline
    static uint64_t fNumGain;             /// Scale for gain values
    static uint64_t fNumTrgOff;           /// Scale for logical baseline

    static std::vector<float>   fStats;   /// Storage for mean and rms values

    /// State of the DRS calibration: Positiove numbers mean that
    /// we are in a run, negative mean that it is closed
    static int  fStep;
    static bool fProcessing;

    DimDescribedService &fDim; // DimService through which statistics updates are transmitted

    void WriteFits();

public:
    DataCalib(uint32_t id, DimDescribedService &dim, MessageImp &imp) : DataProcessorImp(id, imp), fDim(dim)
    {
    }

    static void Restart();
    static void Update(DimDescribedService &dim);

    bool Open(RUN_HEAD* h);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL * = 0);

    static void Apply(int16_t *val, const int16_t *start, uint32_t roi);
    static void Apply(float *vec, int16_t *val, const int16_t *start, uint32_t roi);

    static bool ReadFits(const string &fname, MessageImp &msg);
};

#endif
