/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void dohtml()
{
    //
    //  don't forget that the shared object must have been loaded
    //

    //
    //   create the html document class
    //
    THtml html;

    html.SetOutputDir("htmldoc");
    html.SetSourceDir(".:mbase:mraw:mgui:manalysis:mdatacheck:mmain:meventdisp:mmc:mmontecarlo:mhist:mfilter");

    html.MakeAll(kTRUE);

    html.SetSourceDir("macros");
    html.Convert("merpp.C",       "MARS - Merging and Preprocessing");
    html.Convert("readraw.C",     "MARS - How To Read A Raw");
    html.Convert("rootlogon.C",   "MARS - rootlogon.C");
    html.Convert("readCT1.C",     "MARS - Read and display CT1 Events");
    html.Convert("readMagic.C",   "MARS - Read and display Magic Events");
    html.Convert("CT1Hillas.C",   "MARS - Calculate CT1 Hillas");
    html.Convert("MagicHillas.C", "MARS - Calculate Magic Hillas");
    html.Convert("collarea.C",    "MARS - Calculate Collection Area from a MC root file");
    html.Convert("threshold.C",   "MARS - Calculate Energy Threshold from a MC root file");
    html.Convert("trigrate.C",    "MARS - Calculate Trigger Rate from a MC root file");
}
