/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void readCT1()
{
    MParList plist;

    MGeomCamCT1 geomcam;
    MHillas     hillas;
    MTaskList   tlist;

    plist.AddToList(&geomcam);
    plist.AddToList(&hillas);
    plist.AddToList(&tlist);

    MCT1ReadAscii read("/home/tbretz/data/CT1_97_off1.dat");
    MClone        clone("MCerPhotEvt");
    MImgCleanStd  clean;
    MHillasCalc   hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&clone);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    Int_t icount = 0;
    MCamDisplay display(&geomcam);
    display.Draw();

    while (tlist.Process())
    {
        cout << "Event #" << icount++ << endl;

        display.DrawPhotNum((MCerPhotEvt*)clone.GetClone());
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        hillas.Print();
        hillas.Draw();
        display.DrawPhotNum((MCerPhotEvt*)plist.FindObject("MCerPhotEvt"));

        gClient->HandleInput();
        if(getchar()=='q')
            break;
    } 

    evtloop.PostProcess();
}
