#ifndef MARS_MHHillas
#define MARS_MHHillas

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class MHillas;

class MHHillas : public MH
{
private:
    TH1F *fAlpha;
    TH1F *fWidth;
    TH1F *fLength;
    TH1F *fDist;

public:
     MHHillas(const char *name=NULL, const char *title=NULL);
    ~MHHillas();

    void Fill(const MParContainer *par);

    TH1F *GetHistAlpha()  { return fAlpha; }
    TH1F *GetHistWidth()  { return fWidth; }
    TH1F *GetHistLength() { return fLength; }
    TH1F *GetHistDist()   { return fDist; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHHillas, 1) // Container which hilds hostograms for the Hillas parameters
};

#endif

