#ifndef MARS_MRawRunHeader
#define MARS_MRawRunHeader
///////////////////////////////////////////////////////////////////////
//                                                                   //
// MRunHeader                                                        //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TBuffer;
class ifstream;
class MArrayS;

//
// Magic number to detect the magic file type
//
const UShort_t kMagicNumber = 0xc0c0;

enum {
    kRTData        = 0,
    kRTPedestal    = 1,
    kRTCalibration = 2,
    kRTMonteCarlo  = 256
};

class MRawRunHeader : public MParContainer
{
private:
    /* ---- Run Header Informations ---- */
    UShort_t  fMagicNumber;
    UShort_t  fFormatVersion;
    UShort_t  fSoftVersion;
    UShort_t  fRunType;
    UInt_t    fRunNumber;
    Char_t    fProjectName[22];
    Char_t    fSourceName[12];
    //Float_t   fSourceRA;
    //Float_t   fSourceDEC;
    Char_t    fSourceEpochChar[2];
    UShort_t  fSourceEpochDate;
    Float_t   fMJD;
    UShort_t  fDateYear;
    UShort_t  fDateMonth;
    UShort_t  fDateDay;
    UShort_t  fNumCrates;
    UShort_t  fNumPixInCrate;
    UShort_t  fNumSamplesLoGain;
    UShort_t  fNumSamplesHiGain;
    UInt_t    fNumEvents;
    MArrayS  *fPixAssignment;

public:
    MRawRunHeader(const char *name=NULL, const char *title=NULL);
    ~MRawRunHeader();

    void SetMagicNumber(UShort_t a)  { fMagicNumber=a; }
    void SetFormatVersion(UShort_t a){ fFormatVersion=a; }
    void SetSoftVersion(UShort_t a)  { fSoftVersion=a; }
    void SetRunType(UShort_t a)      { fRunType=a; }
    void SetRunNumber(UInt_t a)      { fRunNumber=a; }
    void SetNumEvents(UInt_t a)      { fNumEvents=a; }
    void SetNumSamples(UShort_t low, UShort_t high)
    {
        fNumSamplesLoGain=low;
        fNumSamplesHiGain=high;
    }
    void SetNumCrates(UShort_t a)    {fNumCrates=a; }
    void SetNumPixInCrate(UShort_t a){fNumPixInCrate=a; }

    UShort_t GetMagicNumber() const       { return fMagicNumber; }
    UShort_t GetFormatversion() const     { return fFormatVersion; }
    UShort_t GetSoftVersion() const       { return fSoftVersion; }
    UShort_t GetRunType() const           { return fRunType; }
    UInt_t   GetRunNumber() const         { return fRunNumber; }
    const Char_t  *GetProjectName() const { return fProjectName; }
    const Char_t  *GetSourceName() const  { return fSourceName; }
    //Float_t  GetSourceRa() const         { return fSourceRA; }
    //Float_t  GetSourceDec() const        { return fSourceDEC; }
    const Char_t  *GetSourceEpocheChar() const { return fSourceEpochChar; }
    UShort_t GetSourceEpocheDate() const  { return fSourceEpochDate; }
    Float_t  GetMJD() const               { return fMJD; }
    UShort_t GetDateYear() const          { return fDateYear; }
    Byte_t   GetDateMonth() const         { return fDateMonth; }
    Byte_t   GetDateDay() const           { return fDateDay; }
    UShort_t GetNumCrates() const         { return fNumCrates; }
    UShort_t GetNumPixInCrate() const     { return fNumPixInCrate; }
    UShort_t GetNumSamplesLoGain() const  { return fNumSamplesLoGain; }
    UShort_t GetNumSamplesHiGain() const  { return fNumSamplesHiGain; }
    UInt_t   GetNumEvents() const         { return fNumEvents; }
    UShort_t GetPixAssignment(UShort_t i) const;

    UInt_t GetNumSamplesPerCrate() const
    {
        return fNumPixInCrate*(fNumSamplesLoGain+fNumSamplesHiGain);
    }

    UShort_t GetNumPixel() const;

    void Print(Option_t *t=NULL) const;

    void ReadEvt(istream& fin);

    ClassDef(MRawRunHeader, 1)	// storage container for general info
};
#endif
