#ifndef BASIC_GL_CAMERA_H_
#define BASIC_GL_CAMERA_H_

#define NBOARDS      40      // max. number of boards
#define NPIX       1440      // max. number of pixels
#define NTMARK      160      // max. number of timeMarker signals

#define MAX_NUM_PIXELS 1600
#define ACTUAL_NUM_PIXELS 1438

#include <QtOpenGL/QGLWidget>
#include <QtGui/QMouseEvent>
#include <vector>

using namespace std;
//#include <QtGui/QMouseEvent>
///structure for storing edges of hexagons (for blurry display)
struct edge
{
    int first;
    int second;
};

///structure for storing neighbors of pixels. For camera position calculation and blurry display
struct PixelsNeighbors
{
    //neighbors. clockwise, starting from top
    int neighbors[6];
    PixelsNeighbors()
    {
        for (int i=0;i<6;i++)
            neighbors[i] = -1;
    }
    int& operator[](int index){return neighbors[index];}
};

class BasicGlCamera : public QGLWidget
{
    Q_OBJECT

public:
    BasicGlCamera(QWidget* parent = 0);
    ~BasicGlCamera();

protected:
    void initializeGL();
    void resizeGL(int width, int height);
    virtual void paintGL();
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseMoveEvent(QMouseEvent *event);
    virtual void mouseDoubleClickEvent(QMouseEvent *event);
    virtual void drawCamera(bool alsoWire);
    virtual void drawPatches();
    int PixelAtPosition(const QPoint &pos);
    void drawHexagon(int index, bool solid);

    int fPixelStride;
    int fcSlice;
    vector<double>fData;

    float ss[5];// = {0.00, 0.25, 0.5, 0.75, 1.00};
    float rr[5];// = {0.15, 0.00, 0.00, 1.00, 0.85};
    float gg[5];// = {0.15, 0.00, 1.00, 0.00, 0.85};
    float bb[5];// = {0.15, 1.00, 0.00, 0.00, 0.85};
 //   bool recalcColorPlease;
    GLfloat pixelsColor[NPIX][3];
    GLfloat verticesList[NPIX*6][2];
    vector<edge> patchesIndices[160];
    int verticesIndices[NPIX][6];
    int pixelsPatch[NPIX];
    int softwareMapping[NPIX];
    int patches[160][9];
    float shownSizex;
    float shownSizey;
private:
    void updateNeighbors(int currentPixel);
    void skipPixels(int start, int howMany);
    void calculatePixelsCoords();
    void buildVerticesList();
    void buildPatchesIndices();
    float hexRadius;
    float hexTolerance;
    float viewSize;
    float pixelSize;
    GLfloat pixelsCoords[MAX_NUM_PIXELS][3];
    PixelsNeighbors neighbors[MAX_NUM_PIXELS];


    int hardwareMapping[NPIX];
    int numVertices;

};

#endif
