#include "QCameraWidget.h"
#include <sstream>
#include <iostream>

    QCameraWidget::QCameraWidget(QWidget *pparent) : BasicGlCamera(pparent)
    {
        fWhite = 0;
        fWhitePatch = pixelsPatch[0];
        fBold.resize(1440);
        fEnable.resize(1440);
        fBold.assign(1440, false);
        fEnable.assign(1440, true);
        fMin = -1;
        fMax = -1;
        lastFace = -1;
        CalculatePixelsColor();

    }
    void QCameraWidget::paintGL()
    {
        glClear(GL_COLOR_BUFFER_BIT);
         glLoadIdentity();

         glTranslatef(0,-0.44,0);
         glScalef(1.5, 1.5, 1.5);
         drawCamera(true);
         drawPatches();

        glLineWidth(1.0f);
        glColor3f(1,1,1);
        drawHexagon(fWhite, false);

        DrawCameraText();
    }
    void QCameraWidget::drawCamera(bool alsoWire)
    {
        if (!pixelColorUpToDate)
            CalculatePixelsColor();
        glLineWidth(1.0);
        for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
        {
            glColor3fv(pixelsColor[i]);
            glLoadName(i);
            drawHexagon(i,true);
        }
        if (!alsoWire)
            return;
        glColor3f(0.0f,0.0f,0.0f);
        for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
        {
            drawHexagon(i, false);
        }
    }
    void QCameraWidget::drawPatches()
    {
        glLineWidth(2.0f);
        glColor3f(patchColour[0],patchColour[1],patchColour[2]);//0.5f, 0.5f, 0.3f);
        glBegin(GL_LINES);
//        for (int i=0;i<NTMARK;i++)
//        {
            for (unsigned int j=0;j<patchesIndices[fWhitePatch].size();j++)
            {
                glVertex2fv(verticesList[patchesIndices[fWhitePatch][j].first]);
                glVertex2fv(verticesList[patchesIndices[fWhitePatch][j].second]);
            }
//        }
        glEnd();
    }
    void QCameraWidget::Reset()
    {
        fBold.assign(1440, false);
    }
    void QCameraWidget::mousePressEvent(QMouseEvent *cEvent)
    {
        int face = PixelAtPosition(cEvent->pos());
        if (face != -1) {
            fWhite = face;
            fWhitePatch = pixelsPatch[fWhite];
            CalculatePatchColor();
            emit signalCurrentPixel(face);
            updateGL();
            }
    }
    void QCameraWidget::mouseMoveEvent(QMouseEvent* cEvent)
    {
        int face = PixelAtPosition(cEvent->pos());
        if (face != -1 && lastFace != face) {
            emit signalPixelMoveOver(face);
        }
        lastFace = face;
    }
    void QCameraWidget::mouseDoubleClickEvent(QMouseEvent* cEvent)
    {
        int face = PixelAtPosition(cEvent->pos());
        if (face != -1) {
            fWhite = face;
            fWhitePatch = pixelsPatch[fWhite];
            CalculatePatchColor();
            emit signalPixelDoubleClick(face);
            updateGL();
        }
    }
     void QCameraWidget::SetBold(int idx)
     {
         //cout << "Boldness not taken into account yet" << endl;
     }
     void QCameraWidget::SetWhite(int idx)
     {
         fWhite = idx;
         fWhitePatch = pixelsPatch[fWhite];
         CalculatePatchColor();
     }
     void QCameraWidget::SetEnable(int idx, bool b)
     {
         fEnable[idx] = b;
     }
     void QCameraWidget::Toggle(int idx)
     {
     }
     double QCameraWidget::GetData(int idx)
     {
         return fData[idx];
     }
     void QCameraWidget::SetMin(int64_t min)
     {
         fMin = min;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::SetMax(int64_t max)
     {
         fMax = max;
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     const char* QCameraWidget::GetName()
     {
         return "QCameraWidget";
     }
     char *QCameraWidget::GetObjectInfo(int px, int py)
     {

         static stringstream stream;
         static string str;
         const int pixel = this->PixelAtPosition(QPoint(px, py));
         if (pixel >= 0)
         {
             stream << "Pixel=" << pixel << "   Data=" << fData[pixel] << '\0';
         }
         str = stream.str();
         return const_cast<char*>(str.c_str());
     }
     void QCameraWidget::CalculatePixelsColor()
     {
         double dmin = fData[0];
          double dmax = fData[0];
          if (fMin < 0 && fMax < 0)
          for (int i=0;i<1440;i++)
          {
              if (!fEnable[i]) continue;
              if (fData[i] > dmax) dmax = fData[i];
              if (fData[i] < dmin) dmin = fData[i];
          }
          if (fMin >= 0) dmin = fMin;
          if (fMax >= 0) dmax = fMax;
          float color;
          for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
           {
               if (fData[i] < dmin)
               {
                   pixelsColor[i][0] = pixelsColor[i][1] = pixelsColor[i][2] = 0;
                   continue;
               }
               if (fData[i] > dmax)
               {
                   pixelsColor[i][0] = pixelsColor[i][1] = pixelsColor[i][2] = 1;
                   continue;
               }
               color = float((fData[i]-dmin)/(dmax-dmin));
               if (!fEnable[i])
                   color = 0;
               int index = 0;
               while (ss[index] < color && index < 4)
                   index++;
               index--;
               if (index < 0) index = 0;
               float weight0 = (color-ss[index]) / (ss[index+1]-ss[index]);
               if (weight0 > 1.0f) weight0 = 1.0f;
               if (weight0 < 0.0f) weight0 = 0.0f;
               float weight1 = 1.0f-weight0;
               pixelsColor[i][0] = weight1*rr[index] + weight0*rr[index+1];
               pixelsColor[i][1] = weight1*gg[index] + weight0*gg[index+1];
               pixelsColor[i][2] = weight1*bb[index] + weight0*bb[index+1];
          }
          CalculatePatchColor();
          pixelColorUpToDate = true;
     }
     void QCameraWidget::CalculatePatchColor()
     {
         //calculate the patch contour color. let's use the anti-colour of the pixels
         GLfloat averagePatchColour[3] = {0.0f,0.0f,0.0f};
         for (int i=0;i<9;i++)
             for (int j=0;j<3;j++)
                 averagePatchColour[j] += pixelsColor[softwareMapping[patches[fWhitePatch][i]]][j];
         for (int j=0;j<3;j++)
             averagePatchColour[j] /= 9;
         for (int j=0;j<3;j++)
             patchColour[j] = 1.0f - averagePatchColour[j];
     }
     void QCameraWidget::SetData(const valarray<double> &ddata)
     {
//             fData = ddata;
         for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
             fData[i] = ddata[i];
         pixelColorUpToDate = false;
         if (isVisible())
             updateGL();
     }
     void QCameraWidget::DrawCameraText()
     {
         glPushMatrix();
         glLoadIdentity();
         cout << width() << " " << height() << endl;
         int textSize = (int)(height()*14/600);
         setFont(QFont("Times", textSize));
         qglColor(QColor(255,223,127));
         float shiftx = 0.01f;//0.55f;
         float shifty = 0.01f;//0.65f;
         renderText(-shownSizex/2.f + shiftx, -shownSizey/2.f + shifty, 0.f, QString("This is a first text that is scaled according to the drawing size"));
         glPopMatrix();
     }
