#ifndef Q_CAMERA_WIDGET_H_
#define Q_CAMERA_WIDGET_H_

#include "BasicGlCamera.h"
#include <valarray>
#include <set>

#include <QtGui/QRadioButton>
#include <QtGui/QLabel>
#include <QtGui/QButtonGroup>

using namespace std;

class QCameraWidget : public BasicGlCamera
{
    Q_OBJECT

    typedef pair<double, double> Position;
    typedef vector<Position> Positions;

    Positions fGeom;

    vector<bool> fBold;
    vector<bool> fEnable;

    int fWhite;
    int fWhitePatch;

    int64_t fMin;
    int64_t fMax;

    int lastFace;

    bool pixelColorUpToDate;

    GLfloat patchColour[3];

    string dataText;
    string unitsText;
    string titleText;

public:
    void setUnits(string& units);
    void setTitle(string& title);
    QCameraWidget(QWidget *pparent = 0);
    void paintGL();
    void mousePressEvent(QMouseEvent *cEvent);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);
    void Reset();
    void drawCamera(bool alsoWire);
    void drawPatches();
     void SetBold(int idx);
     void SetWhite(int idx);
     void SetEnable(int idx, bool b);
     void Toggle(int idx);
     double GetData(int idx);
     void SetMin(int64_t min);
     void SetMax(int64_t max);
     const char *GetName();

     int GetIdx(float px, float py);
     char *GetObjectInfo(int px, int py);

     void SetData(const valarray<double> &ddata);

public Q_SLOTS:
        void linearScalePlease(bool);
        void logScalePlease(bool);
        void regularPalettePlease(bool);
        void prettyPalettePlease(bool);
        void greyScalePalettePlease(bool);
        void glowingPalettePlease(bool);
        void zeroRotationPlease(bool);
        void plus90RotationPlease(bool);
        void minus90RotationPlease(bool);

Q_SIGNALS:
         void signalCurrentPixel(int pixel);
         void signalPixelMoveOver(int pixel);
         void signalPixelDoubleClick(int pixel);

private:
     void CalculatePixelsColor();
     void CalculatePatchColor();
     void DrawCameraText();
     void UpdateText();
     void DrawScale();
     void toggleInterfaceDisplay();
     void repaintInterface();
     QRadioButton* linearButton;
     QRadioButton* logButton;
     QRadioButton* regularPaletteButton;
     QRadioButton* prettyPaletteButton;
     QRadioButton* greyScalePaletteButton;
     QRadioButton* glowingPaletteButton;
     QRadioButton* zeroRotationButton;
     QRadioButton* minus90RotationButton;
     QRadioButton* plus90Rotationbutton;
     QLabel*       scaleLabel;
     QLabel*       colorPaletteLabel;
     QLabel*       rotationLabel;
     QButtonGroup* scaleGroup;
     QButtonGroup* colorGroup;
     QButtonGroup* rotationGroup;

     bool logScale;
     int cameraRotation;
};

typedef QCameraWidget Camera;
#endif
