#ifndef HV_H_SEEN
#define HV_H_SEEN

#include <termios.h>		// POSIX terminal control definitions
#include <fcntl.h>		// File control definitions => fcntl() in fcn OpenPort()
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <string>
#include <vector>
#include <map>

#include "dis.hxx"

const unsigned int MAX_NUM_BOARDS = 13;	// Maximum number of boards per crate
const unsigned int NUM_CHANNELS = 32;	// Channels per bias board
const float RESISTOR = 1000;			// Resistance in Ohm for voltage correction
const int MAX_ERR_COUNT = 10;	// Maximum number of errors before reporting stopped
class User;

class Crate {
  
    class User *m;
	int CrateNumber;
	int fDescriptor;
	FILE *File;
	DimService *NameService;
	DimService *BiasVolt;
	DimService *BiasCurrent;

	double Volt[MAX_NUM_BOARDS*NUM_CHANNELS];	// Voltage
	float Current[MAX_NUM_BOARDS*NUM_CHANNELS];
	time_t LastReset;

	std::vector<unsigned char> Communicate(std::string);
	void ClearVoltageArrays();
   
  public:
    Crate(std::string, int, class User *);
    ~Crate();

    char *Name;

	bool OC[MAX_NUM_BOARDS*NUM_CHANNELS];
	bool Present[MAX_NUM_BOARDS*NUM_CHANNELS];
	bool ResetHit;
	bool WrapOK;
	int WrapCount;
	int ErrorCount;
	bool Disabled;

	float RefCurrent[MAX_NUM_BOARDS*NUM_CHANNELS];
	double RefVolt[MAX_NUM_BOARDS*NUM_CHANNELS];

	bool InitOK;

	bool SetChannels(std::map<unsigned int, double>);
	bool ReadAll();
	bool SystemReset();
	bool GlobalSet(double);
	bool Synch();
	double GetVoltage(unsigned int);
	unsigned int GetDAC(unsigned int);
	float GetCurrent(unsigned int);
	void UpdateDIM();
	void SetRefCurrent();
	void AdaptVoltages();
};

#endif
