/**************************************************************\

  Control program for the FACT G-APD bias supply

  Oliver Grimm
  
\**************************************************************/

#include <stdio.h>

#include "User.h"

#include <readline/readline.h>
#include <readline/history.h>

using namespace std;

const string READLINE_HIST_FILE = string(getenv("HOME"))+"/.history_BIASctrl";

// Main program
int main() {

  char *Command;
  std::string LastHist;

  // Uses getc() for readline library (allows interruption by signal) and load history buffer
  rl_getc_function = getc;
  read_history(READLINE_HIST_FILE.c_str());

  // Set signal SIGTERM to interrupt blocking system calls
  siginterrupt(SIGTERM, true);

  if (system("clear") == -1) printf("Error with system() call\n");
                   
  printf("\n*** BIASctrl (compiled %s, %s) ***\n\n", __DATE__, __TIME__);
   
  // Construct main instance
  static User M;
  
  // Handle command-line input
  while (!M.ExitRequest) {        
    Command = readline("Bias> ");
	
	// NULL returned if interrupted by signal
    if (Command == NULL) continue;

	// Add command to history
    if(strlen(Command) > 0 && LastHist != Command) {
	  add_history(Command);
	  LastHist = Command;
	}

    // Process command (via DIM gives automatic thread serialisation)
	DimClient::sendCommand("Bias/Command", Command);
    free(Command);
  }
  
  // Save history buffer  
  int Ret = write_history(READLINE_HIST_FILE.c_str());
  if (Ret != 0 ) printf("Error writing history file to '%s' (%s)\n", READLINE_HIST_FILE.c_str(), strerror(Ret));
}
