#include "MessageDim.h"

#include "tools.h"
#include "Time.h"

#include <iostream>

#include "DimDescriptionService.h"

int main(int, const char **)
{
    // We could use putenv to make the Configure class change the value...
    setenv("DIM_DNS_NODE", "localhost", 0);

    // Start a DimServer called TIME
    DimServer::start("TIME");

    usleep(2000000);

    DimServer::stop();

    return 0;

    // Some info on the console
    std::cout << "Offering TIME/MESSAGE...\n" << std::endl;

    short s;
    int i;
    long long ll;
    float f;
    DimDescribedService servt("TIME/TEST", "O:1;I:1;C",
                              "This is my test command|Char[c]:This is a char|   Int This is an int|String[s]:This is a string");

    DimDescribedService servs("TIME/SHORT",     s,  "[a]");
    DimDescribedService servx("TIME/LONGLONG",  ll, "|: This is my long long");
    DimDescribedService servi("TIME/INT",       i,  "|MyInt  [  mi  ] ");
    DimDescribedService servf("TIME/FLOAT",     f,  "|   MyFloat  :   This is my float");
    DimDescribedService servc("TIME/TIME", const_cast<char*>(""), "|MyTime[T]:This is my time");

    DimCommand cmd("TIME/CMD", "I:2;F:2");

    DimDescriptionService des("TIME/CMD", "|range[addr]:From DAC to DAC|values[DAC]:DAC values to be set");

    {
    Time t0;

    // Setup a DimService called TIME/MESSAGE
    MessageDimTX msg("TIME");
    while (1)
    {
        // Send current time
        msg.Message(Time().GetAsStr());
//        servx.Update();
        /*
        servs.updateService();
        servi.updateService();
        servf.updateService();
        servc.updateService();
         */
        // wait approximately one second
        usleep(100000);

//        if (t0.UnixTime()-Time().UnixTime()<-5)
//            break;
    }
    }

    DimDescribedService servxx("TIME/XXX", const_cast<char*>(""), "|MyTime[T]:This is my time");
    usleep(10000000);

    return 0;
}

// **************************************************************************
/** @example logtime.cc

This is a simple example how to log messages through the Dim network
using MessageDimTX. Here we are offering the time once a second.

The program is stopped by CTRL-C

*/
// **************************************************************************
