
unsigned char ReadFromDataBus(){
	// The eight bits of the databus are distributed over
	// the two differen ports of the ATmega. Port C and D
	// actually they are connected like this:
	// data0...data3 are connected to Arduino Pins D4..D7
	// data4...data7 are connected to Arduino Pins C0..D3
	return  ( (PINC&0x0f) << 4 ) | ( (PIND&0xf0) >> 4)  ;
}

void PutOnDataBus ( unsigned char data) {
	// okay .. .again
	// data0..3 is connected to PD4..7
	// data4..7 is connected to PC0..3
	PORTC = (PORTC & 0xf0) | (data&0xf0)>>4 ;
	PORTD = (PORTD & 0x0f) | (data&0x0f)<<4 ;
}


void MakeDataBusOutput() {
  // making the databus out can be done like this:
	// data0..3 is connected to PD4..7
	// data4..7 is connected to PC0..3

  // also auf PORTC die bits 0 bis 3 setzen!
  DDRC |= 0x0f;
  // und auf PORTD die bits 4 bis 7 setzen!
  DDRD |= 0xf0;

  // Um die Pullups muss man sicht nicht kümmern, da nach dieser Funktion sowieso ein neuer Wert auf den Bus
  // geschrieben wird.
}

void MakeDataBusInput() {
// see the comments in MakeDataBusOutput()

//first we switch the outs to ins
// then we switch on the pullups

  DDRC &= 0xf0;
  DDRD &= 0x0f;
// now the pull ups
  PORTC |= 0x0f;
  PORTD |= 0xf0;
}
