#include <cstdio>
int FPedestalAllPx(
    fits &datafile,
    vector<int16_t> &data,
    vector<int16_t> &data_offset,
    vector<float> &drs_basemean,
    vector<float> &drs_gainmean,
    vector<float> &drs_triggeroffsetmean,
    UInt_t data_px,
    UInt_t data_roi,
    float pedestal_mean[],
    float pedestal_rms[] )
{
//	TCanvas *canv_base = new TCanvas( "canv_base", "Determine the baseline", 100, 520, 700, 500 );
//	canv_base->SetLogy();

	char title_base[500];
	char name_base[50];
	TH1F* baseline[data_px];
	for(int i=0; i<data_px; i++) {

		std::sprintf(title_base,"Baseline of Px %i",i);
		std::sprintf(name_base,"base%i",i);

		baseline[i] = new TH1F(name_base,title_base,2000,-99.5,100.5);
		baseline[i]->GetXaxis()->SetTitle("Sample value (mV)");
		baseline[i]->GetYaxis()->SetTitle("Entries");
	}
	
//-------------------------------------------
//Find the baseline
//-------------------------------------------
	for (size_t i=0; ( i<datafile.GetNumRows() ); i++)
	{
		datafile.GetRow(i);
		if( i%50 == 0 ) cout << "Loop variable: " << i << endl;
		
		//Iterate over the pixels
		for (int j=0; j<data_px; j++)
		{
//		size_t j=pixelnr; //Fix the Pixel to a SoftID

			//Iterate over the slices
			for (UInt_t k=0; k<data_roi; k++)
			{
				UInt_t drs_calib_offset = (k+data_offset[j])%data_roi;
				float sample = (data[j*data_roi+k]*2000/4096.-drs_basemean[j*data_roi+drs_calib_offset]-drs_triggeroffsetmean[j*data_roi+k])/drs_gainmean[j*data_roi+drs_calib_offset]*1907.35;
				baseline[j]->Fill(sample);
				
				//Original code
				//UInt_t drs_calib_offset = (k+data_offset[j])%data_roi;
				//float sample = (data[j*data_roi+k]*2000/4096.-drs_basemean[j*data_roi+drs_calib_offset]-drs_triggeroffsetmean[j*data_roi+k])/drs_gainmean[j*data_roi+drs_calib_offset]*1907.35;
				//baseline->Fill(sample);
			}
		}
	}
	
	for (int j=0; j<data_px; j++) {
		pedestal_mean[j] = baseline[j]->GetXaxis()->GetBinCenter(baseline[j]->GetMaximumBin());
		pedestal_rms[j] = baseline[j]->GetRMS();
	}
//	std::cout << "Value of maximal probability Px 1348: " << pedestal_mean[1348] << " +- " << pedestal_rms[1348] << std::endl;
	
//	canv_base->cd();
//	baseline->Draw();
//	canv_base->Modified();
//	canv_base->Update();
	
	return 0;
}
