#include <TROOT.h>
#include <TCanvas.h>
#include <TH1.h>

#include <stdint.h>
#include <cstdio>

#include "fits.h"
#include "FOpenDataFile.c"
#include "FOpenCalibFile.c"
#include "FPedestalAllPx.c"

int testFPedestalAllPx(
    const char *name = "../raw/20110916_025.fits",
    const char *drsname = "../raw/20110916_024.drs.fits")
{
//******************************************************************************
//Read a datafile and plot the DRS-calibrated data
//ATTENTION: only works for ROI=1024
// (array indices of the calibration wrong otherwise)
//Example call in ROOT:
//root [74] .x calscope.C++("20110804_024.fits","20110804_023.drs.fits",10,1348)
//T. Kr�henb�hl, August 2011, tpk@phys.ethz.ch
//******************************************************************************

	gROOT->SetStyle("Plain");
	
//-------------------------------------------
//Open the file
//-------------------------------------------
	fits datafile(name);
	if (!datafile)
	{
	cout << "Couldn't properly open the datafile." << endl;
	return 1;
	}
	
//-------------------------------------------
//Get the data
//-------------------------------------------
	vector<int16_t> data;
	vector<int16_t> data_offset;
	unsigned int data_num;
	size_t data_n;
	UInt_t data_px;
	UInt_t data_roi;
	FOpenDataFile(datafile, data, data_offset, data_num, data_n, data_roi, data_px);
	
//-------------------------------------------
//Get the DRS calibration
//-------------------------------------------
	size_t drs_n;
	vector<float> drs_basemean;
	vector<float> drs_gainmean;
	vector<float> drs_triggeroffsetmean;
    
	FOpenCalibFile(drsname, drs_basemean, drs_gainmean, drs_triggeroffsetmean, drs_n);
	
    
//-------------------------------------------
//Check the sizes of the data columns
//-------------------------------------------
	if(drs_n!=data_n)
	{
		cout << "Data and DRS file incompatible (Px*ROI disagree)" << endl;
		return 1;
	}
    else{
        cout << "Data and DRS file compatible" << endl;
        // continue
    }
	
	
//-------------------------------------------
//Create the title
//-------------------------------------------
//	char title[500];
//	std::sprintf(title,"Data: %s, DRS: %s, Px %i Ev %i",name,drsname,pixelnr,eventnr);
	
//-------------------------------------------
//Get the pedestals & RMS
//-------------------------------------------
	float pedestal_mean[data_px];
	float pedestal_rms[data_px];

	FPedestalAllPx(datafile, data, data_offset, drs_basemean, drs_gainmean, drs_triggeroffsetmean, data_px, data_roi, pedestal_mean, pedestal_rms);

//	vector<float> calevent(data_px*data_roi); //Vector for the calibrated event
//	FGetCalEvent(data, data_offset, drs_basemean, drs_gainmean, drs_triggeroffsetmean, calevent, data_px, data_roi);
	
//-------------------------------------------
//Draw the data
//-------------------------------------------
    
	TCanvas *canv_mean= new TCanvas( "canv_mean", "mean in mV", 30, 300, 900, 500 );
	TH1F* histo_mean = new TH1F("histo_mean","Value of maximal probability",2000,-99.5,100.5);
	TCanvas *canv_rms= new TCanvas( "canv_rms", "RMS in mV", 960, 300, 900, 500 );
	TH1F* histo_rms = new TH1F("histo_rms","RMS in mV",2000,-99.5,100.5);
	
	for (int j=0; j<data_px; j++)
	{
		histo_mean->Fill(pedestal_mean[j]);
		histo_rms->Fill(pedestal_rms[j]);
	}
//	histo_mean->GetYaxis()->SetRangeUser(0,150);
	
	canv_mean->cd();
	histo_mean->Draw();
	canv_mean->Modified();
	canv_mean->Update();
	canv_rms->cd();
	histo_rms->Draw();
	canv_rms->Modified();
	canv_rms->Update();
	
	return 0;
}
