#include <TROOT.h>
#include <TCanvas.h>
#include <TProfile.h>
#include <TH2.h>
#include <stdint.h>
#include <cstdio>

#include "fits.h"
#include "FOpenDataFile.c"
#include "FOpenCalibFile.c"

int calscope_average(const char *name, const char *drsname, UInt_t maxevents)
{
//******************************************************************************
//Read a datafile and plot the average over all pixels of the first DRS-calibrated events
//ATTENTION: only works for ROI=1024
//(array indices of the calibration wrong otherwise)
//Example call in ROOT:
//root [74] .x calscope_average.C++("/loc_data/rawdata/2011/09/10/20110910_020.fits","/loc_data/rawdata/2011/09/09/20110909_043.drs.fits",10)
//T. Krhenbhl, September 2011, tpk@phys.ethz.ch
//******************************************************************************

	gROOT->SetStyle("Plain");
	
//-------------------------------------------
//Open the file
//-------------------------------------------
	fits datafile(name);
	if (!datafile)
	{
	cout << "Couldn't properly open the datafile." << endl;
	return 1;
	}
	
//-------------------------------------------
//Get the data
//-------------------------------------------
	vector<int16_t> data;
	vector<int16_t> data_offset;
	unsigned int data_num;
	size_t data_n;
	UInt_t data_px;
	UInt_t data_roi;
	FOpenDataFile(datafile, data, data_offset, data_num, data_n, data_roi, data_px);
	
//-------------------------------------------
//Get the DRS calibration
//-------------------------------------------
	size_t drs_n;
	vector<float> drs_basemean;
	vector<float> drs_gainmean;
	vector<float> drs_triggeroffsetmean;
	FOpenCalibFile(drsname, drs_basemean, drs_gainmean, drs_triggeroffsetmean, drs_n);
	
//-------------------------------------------
//Check the sizes of the data columns
//-------------------------------------------
	if(drs_n!=data_n)
	{
		cout << "Data and DRS file incompatible (Px*ROI disagree)" << endl;
		return 1;
	}
	
//-------------------------------------------
//Create the canvas, plot and title
//-------------------------------------------
	char title[500];
	std::sprintf(title,"Data: %s, DRS: %s",name,drsname);
	TCanvas *canv = new TCanvas( "canv", "Mean values of the first events", 100, 10, 700, 500 );
	TProfile *pix = new TProfile("pix", title, 1024, -0.5, 1023.5);
	pix->GetXaxis()->SetTitle("DRS bin (@2 GHz)");
	pix->GetYaxis()->SetTitle("Amplitude (mV)");
	
//	char ptitle[500];
//	std::sprintf(ptitle,"Data: %s, DRS: %s, Px %i",name,drsname);
//	TCanvas *pcanv = new TCanvas( "pcanv", title, 800, 10, 700, 500 );
//	TH2F *pers = new TH2F("pers",ptitle,1024,-0.5,1023.5,1550,-49.5,1500.5);
//	pers->GetXaxis()->SetTitle("DRS bin (@2 GHz)");
//	pers->GetYaxis()->SetTitle("Amplitude (mV)");
	
//-------------------------------------------
//Iterate over the events
//-------------------------------------------
if((maxevents==0)||(maxevents>datafile.GetNumRows())) maxevents = datafile.GetNumRows();
	for (size_t i=0; i<maxevents; i++)
	{
		datafile.GetRow(i);
		cout << "Event number: " << data_num << endl;
		
//-------------------------------------------
//Iterate over the pixels
//-------------------------------------------
		for (int j=0; j<data_px; j++)
		{
		
//-------------------------------------------
//Iterate over the slices
//-------------------------------------------
			for (UInt_t k=0; k<data_roi; k++)
			{
				UInt_t drs_calib_offset = (k+data_offset[j])%data_roi;
				//Example values for the various datasets (20110803_015 / 018?9)
				//data = -1856 +- 30.76
				//drs_basemean = -906.6 +- 14.73
				//drs_gainmean = 1696 +- 4
				//drs_triggeroffsetmean = -0.01 +- 1.532
				
				//Gain calibration to mV: 50000(DAC) / drs_gainmean(ADC) * 2500(mV) / 65536(DAC)
				//Target value: 1.907 V fr DRS-Calib files beim DAC-Wert 50000
				float sample = (data[j*data_roi+k]*2000/4096.-drs_basemean[j*data_roi+drs_calib_offset]-drs_triggeroffsetmean[j*data_roi+k])/drs_gainmean[j*data_roi+drs_calib_offset]*1907.35;
				pix->Fill(k,sample);
//				pers->Fill(k,sample);
			}
		}
	}

//-------------------------------------------
//Draw the data
//-------------------------------------------
	canv->cd();
	pix->Draw();
	canv->Modified();
	canv->Update();
//	pcanv->cd();
//	pers->Draw("col");
//	pcanv->Modified();
//	pcanv->Update();
	return 0;
}
