#include <stdio.h>
#include <iostream>


// this function reads a (hopefully smoothed, and baseline corrected) DRS pipeline and produces 
// three vectors 
// 1. start of 'over threshold'
// 2. end of 'over threshold'
// 3. max within this 'over threshold' region
//
// it needs a threshold and the length of the falling edge 

#include "discriminator.h"

vector<DiscOut> * discriminator(
		vector<float>& input, 			// vector of floats, the discriminator acts on
		float thr = 5., 						// threshold
		int fallingEdge = 100	)			// number of slices, after the maximum, which should be discarded...
{

	vector<DiscOut> * result = new vector<DiscOut>;
	DiscOut disc;
	disc.begin = 0;
	disc.end = 0;
	disc.maxPos = 0;
	disc.maxVal = 0.;
	bool start_under_thr = false;
	bool over_thr_found = false;


	bool debug = false; // switch to true in order to generate some output.

	for ( int sl = 0; sl < input.size() ; sl++ ){


			if ( input[sl] > thr ) {
				
				if ( !over_thr_found ) {
					over_thr_found = true;
					disc.begin = sl;
				}

				if ( input[sl] > disc.maxVal) {
					disc.maxVal = input[sl];
					disc.maxPos = sl;
				}
			}
			if ( input[sl] < thr ) {
				if ( over_thr_found ) {
					over_thr_found = false;
					disc.end = sl;
				
					result->push_back(disc);
					disc.begin = 0;
					disc.end = 0;
					disc.maxPos = 0;
					disc.maxVal = 0.;

				}
			}		
	} // end of for llop over all slices

		if (debug){  // output the vector
			for (int p=0; p<result->size(); p++ ){
				cout << p << ":\t"; 
				cout << result->at(p).begin << "\t";
				cout << result->at(p).end << "\t";
				cout << result->at(p).maxPos << "\t";
				cout << result->at(p).maxVal << endl;
			}
		}

DiscOut last;
vector<DiscOut> * realresult = new vector<DiscOut>;
	
if (result->size() > 0) {	
	while (!result->empty()){

		last.begin = result->back().begin;
		last.end = result->back().end;
		last.maxPos = result->back().maxPos;
		last.maxVal = result->back().maxVal;
		result->pop_back();

		if (result->empty()){
			if (last.maxPos > 0)
				realresult->push_back(last);
			break;
		}
		if (last.maxPos - result->back().maxPos > fallingEdge)
			realresult->push_back(last);
	}
}
/*
	vector<vector<DiscOut>::iterator> toBeDeleted;

	for (vector<DiscOut>::iterator it=result->begin(); it != result->end()-1; ++it ){
		if ( (*it).begin==0 ){
				toBeDeleted.push_back(it);
		}
		if ( ((*(it+1)).maxPos - (*it).maxPos) < fallingEdge ){
			toBeDeleted.push_back(it);
			}
	}		

	for (int i=0; i<toBeDeleted.size(); i++) {
		result->erase(toBeDeleted[i]);
		if (debug)
			cout << "erased peak at:" << (*toBeDeleted[i]).maxPos << endl;
	}
*/

delete result;
return realresult;

} // end of function - discriminator
