#include "fits.h"

#include <stdint.h>

int test(const char *name)
{
    fits file(name);
    if (!file)
    {
        cout << "Couldn't properly open the file." << endl;
        return 1;
    }

    cout << "-------------------- Header -------------------" << endl;
    file.PrintKeys();
    cout << "------------------- Columns -------------------" << endl;
    file.PrintColumns();

    cout << "--------------------- Data --------------------" << endl;

    unsigned int num;
    short type;

    const size_t n   = file.GetN("Data");     // Size of column "Data"
    const UInt_t roi = file.GetUInt("NROI");  // Value from header

    vector<int16_t> data(n);

    file.SetRefAddress("EventNum",    num);
    file.SetRefAddress("TriggerType", type);
    file.SetVecAddress("Data",        data);

    for (size_t i=0; i<file.GetNumRows(); i++)
    {
        file.GetRow(i);
        cout << "Event number: " << num << endl;

        for (int j=0; j<1440; j++)
            for (UInt_t k=0; k<roi; k++)
            {
                int16_t sample = data[j*roi+k];
                sample+=0; // Supress compiler warning
            }
    }

    return 0;
}
