#include <TROOT.h>
#include <TCanvas.h>
#include <TProfile.h>

#include <stdint.h>
#include <cstdio>

#define HAVE_ZLIB
#include "fits.h"
#include "TPKplotevent.c"
#include "FOpenDataFile.c"
#include "FOpenCalibFile.c"

int calscope(const char *name = "../raw/20110916_025.fits", const char *drsname = "../raw/20110916_024.drs.fits", size_t eventnr = 0, size_t pixelnr = 0)
{
//******************************************************************************
//Read a datafile and plot the DRS-calibrated data
//ATTENTION: only works for ROI=1024
// (array indices of the calibration wrong otherwise)
//Example call in ROOT:
//root [74] .x calscope.C++("20110804_024.fits","20110804_023.drs.fits",10,1348)
//T. Krähenbühl, August 2011, tpk@phys.ethz.ch
//******************************************************************************

	gROOT->SetStyle("Plain");
	
//-------------------------------------------
//Open the file
//-------------------------------------------
	fits datafile(name);
	if (!datafile)
	{
	cout << "Couldn't properly open the datafile." << endl;
	return 1;
	}
	
//-------------------------------------------
//Get the data
//-------------------------------------------
	vector<int16_t> data;
	vector<int16_t> data_offset;
	unsigned int data_num;
	size_t data_n;
	UInt_t data_px;
	UInt_t data_roi;
	FOpenDataFile(datafile, data, data_offset, data_num, data_n, data_roi, data_px);
	
//-------------------------------------------
//Get the DRS calibration
//-------------------------------------------
	size_t drs_n;
	vector<float> drs_basemean;
	vector<float> drs_gainmean;
	vector<float> drs_triggeroffsetmean;
	FOpenCalibFile(drsname, drs_basemean, drs_gainmean, drs_triggeroffsetmean, drs_n);
	
//-------------------------------------------
//Check the sizes of the data columns
//-------------------------------------------
	if(drs_n!=data_n)
	{
		cout << "Data and DRS file incompatible (Px*ROI disagree)" << endl;
		return 1;
	}
	
	
//-------------------------------------------
//Create the title
//-------------------------------------------
	char title[500];
	std::sprintf(title,"Data: %s, DRS: %s, Px %i Ev %i",name,drsname,pixelnr,eventnr);
	
//-------------------------------------------
//Get the event
//-------------------------------------------
	cout << "--------------------- Data --------------------" << endl;
	datafile.GetRow(eventnr);
	cout << "Event number: " << data_num << endl;
		
//-------------------------------------------
//Draw the data
//-------------------------------------------
	TPKplotevent(title, data, data_offset, drs_basemean, drs_gainmean, drs_triggeroffsetmean, data_roi, pixelnr);
	return 0;
}
